/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.UUID;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.InetEndpoint;
import org.gradle.messaging.remote.internal.inet.MultiChoiceAddress;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.ChannelUnavailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.gradle.messaging.remote.internal.protocol.UnknownMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryProtocolSerializer
implements MessageSerializer<DiscoveryMessage> {
    public static final byte PROTOCOL_VERSION = 1;
    public static final byte LOOKUP_REQUEST = 1;
    public static final byte CHANNEL_AVAILABLE = 2;
    public static final byte CHANNEL_UNAVAILABLE = 3;

    @Override
    public DiscoveryMessage read(DataInputStream dataInputStream, InetEndpoint inetEndpoint, InetEndpoint inetEndpoint2) throws Exception {
        byte by = dataInputStream.readByte();
        if (by != 1) {
            return new UnknownMessage(String.format("unknown protocol version %s", by));
        }
        byte by2 = dataInputStream.readByte();
        switch (by2) {
            case 1: {
                return this.readLookupRequest(dataInputStream);
            }
            case 2: {
                return this.readChannelAvailable(dataInputStream, inetEndpoint2);
            }
            case 3: {
                return this.readChannelUnavailable(dataInputStream);
            }
        }
        return new UnknownMessage(String.format("unknown message type %s", by2));
    }

    private DiscoveryMessage readChannelUnavailable(DataInputStream dataInputStream) throws IOException {
        MessageOriginator messageOriginator = this.readMessageOriginator(dataInputStream);
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        MultiChoiceAddress multiChoiceAddress = this.readAddress(dataInputStream);
        return new ChannelUnavailable(messageOriginator, string, string2, multiChoiceAddress);
    }

    private DiscoveryMessage readChannelAvailable(DataInputStream dataInputStream, InetEndpoint inetEndpoint) throws IOException {
        MessageOriginator messageOriginator = this.readMessageOriginator(dataInputStream);
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        MultiChoiceAddress multiChoiceAddress = this.readAddress(dataInputStream);
        multiChoiceAddress = multiChoiceAddress.addAddresses(inetEndpoint.getCandidates());
        return new ChannelAvailable(messageOriginator, string, string2, multiChoiceAddress);
    }

    private DiscoveryMessage readLookupRequest(DataInputStream dataInputStream) throws IOException {
        MessageOriginator messageOriginator = this.readMessageOriginator(dataInputStream);
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        return new LookupRequest(messageOriginator, string, string2);
    }

    private MessageOriginator readMessageOriginator(DataInputStream dataInputStream) throws IOException {
        UUID uUID = this.readUUID(dataInputStream);
        String string = dataInputStream.readUTF();
        return new MessageOriginator(uUID, string);
    }

    private MultiChoiceAddress readAddress(DataInputStream dataInputStream) throws IOException {
        UUID uUID = this.readUUID(dataInputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            arrayList.add(inetAddress);
        }
        return new MultiChoiceAddress(uUID, n, arrayList);
    }

    private UUID readUUID(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        long l2 = dataInputStream.readLong();
        return new UUID(l, l2);
    }

    @Override
    public void write(DiscoveryMessage discoveryMessage, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeByte(1);
        if (discoveryMessage instanceof LookupRequest) {
            this.writeLookupRequest(dataOutputStream, (LookupRequest)discoveryMessage);
        } else if (discoveryMessage instanceof ChannelAvailable) {
            this.writeChannelAvailable(dataOutputStream, (ChannelAvailable)discoveryMessage);
        } else if (discoveryMessage instanceof ChannelUnavailable) {
            this.writeChannelUnavailable(dataOutputStream, (ChannelUnavailable)discoveryMessage);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void writeChannelUnavailable(DataOutputStream dataOutputStream, ChannelUnavailable channelUnavailable) throws IOException {
        dataOutputStream.writeByte(3);
        this.writeMessageOriginator(dataOutputStream, channelUnavailable.getOriginator());
        dataOutputStream.writeUTF(channelUnavailable.getGroup());
        dataOutputStream.writeUTF(channelUnavailable.getChannel());
        this.writeAddress(dataOutputStream, (MultiChoiceAddress)channelUnavailable.getAddress());
    }

    private void writeChannelAvailable(DataOutputStream dataOutputStream, ChannelAvailable channelAvailable) throws IOException {
        dataOutputStream.writeByte(2);
        this.writeMessageOriginator(dataOutputStream, channelAvailable.getOriginator());
        dataOutputStream.writeUTF(channelAvailable.getGroup());
        dataOutputStream.writeUTF(channelAvailable.getChannel());
        this.writeAddress(dataOutputStream, (MultiChoiceAddress)channelAvailable.getAddress());
    }

    private void writeLookupRequest(DataOutputStream dataOutputStream, LookupRequest lookupRequest) throws IOException {
        dataOutputStream.writeByte(1);
        this.writeMessageOriginator(dataOutputStream, lookupRequest.getOriginator());
        dataOutputStream.writeUTF(lookupRequest.getGroup());
        dataOutputStream.writeUTF(lookupRequest.getChannel());
    }

    private void writeMessageOriginator(DataOutputStream dataOutputStream, MessageOriginator messageOriginator) throws IOException {
        this.writeUUID(dataOutputStream, messageOriginator.getId());
        dataOutputStream.writeUTF(messageOriginator.getName());
    }

    private void writeAddress(DataOutputStream dataOutputStream, MultiChoiceAddress multiChoiceAddress) throws IOException {
        this.writeUUID(dataOutputStream, multiChoiceAddress.getCanonicalAddress());
        dataOutputStream.writeInt(multiChoiceAddress.getPort());
        dataOutputStream.writeInt(multiChoiceAddress.getCandidates().size());
        for (InetAddress inetAddress : multiChoiceAddress.getCandidates()) {
            byte[] byArray = inetAddress.getAddress();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    private void writeUUID(DataOutputStream dataOutputStream, Object object) throws IOException {
        UUID uUID = (UUID)object;
        dataOutputStream.writeLong(uUID.getMostSignificantBits());
        dataOutputStream.writeLong(uUID.getLeastSignificantBits());
    }
}

