/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.ConnectException;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.inet.InetEndpoint;
import org.gradle.messaging.remote.internal.inet.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpOutgoingConnector<T>
implements OutgoingConnector<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpOutgoingConnector.class);
    private final MessageSerializer<T> serializer;

    public TcpOutgoingConnector(MessageSerializer<T> messageSerializer) {
        this.serializer = messageSerializer;
    }

    @Override
    public Connection<T> connect(Address address) {
        if (!(address instanceof InetEndpoint)) {
            throw new IllegalArgumentException(String.format("Cannot create a connection to address of unknown type: %s.", address));
        }
        InetEndpoint inetEndpoint = (InetEndpoint)address;
        LOGGER.debug("Attempting to connect to {}.", (Object)inetEndpoint);
        List<InetAddress> list = inetEndpoint.getCandidates();
        try {
            SocketException socketException = null;
            for (InetAddress inetAddress : list) {
                SocketChannel socketChannel;
                LOGGER.debug("Trying to connect to address {}.", (Object)inetAddress);
                try {
                    socketChannel = SocketChannel.open(new InetSocketAddress(inetAddress, inetEndpoint.getPort()));
                }
                catch (SocketException socketException2) {
                    LOGGER.debug("Cannot connect to address {}, skipping.", (Object)inetAddress);
                    socketException = socketException2;
                    continue;
                }
                LOGGER.debug("Connected to address {}.", (Object)inetAddress);
                return new SocketConnection<T>(socketChannel, this.serializer);
            }
            throw socketException;
        }
        catch (java.net.ConnectException connectException) {
            throw new ConnectException(String.format("Could not connect to server %s. Tried addresses: %s.", address, list), connectException);
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not connect to server %s. Tried addresses: %s.", address, list), exception);
        }
    }
}

