/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.Action;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;
import org.gradle.messaging.remote.internal.inet.MultiChoiceAddress;
import org.gradle.messaging.remote.internal.inet.SocketConnection;
import org.gradle.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpIncomingConnector<T>
implements IncomingConnector<T>,
AsyncStoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpIncomingConnector.class);
    private final StoppableExecutor executor;
    private final MessageSerializer<T> serializer;
    private final IdGenerator<?> idGenerator;
    private final List<InetAddress> localAddresses;
    private final List<InetAddress> remoteAddresses;
    private final List<ServerSocketChannel> serverSockets = new CopyOnWriteArrayList<ServerSocketChannel>();

    public TcpIncomingConnector(ExecutorFactory executorFactory, MessageSerializer<T> messageSerializer, InetAddressFactory inetAddressFactory, IdGenerator<?> idGenerator) {
        this.serializer = messageSerializer;
        this.idGenerator = idGenerator;
        this.executor = executorFactory.create("Incoming TCP Connector");
        this.localAddresses = inetAddressFactory.findLocalAddresses();
        this.remoteAddresses = inetAddressFactory.findRemoteAddresses();
    }

    @Override
    public Address accept(Action<ConnectEvent<Connection<T>>> action, boolean bl) {
        int n;
        ServerSocketChannel serverSocketChannel;
        try {
            serverSocketChannel = ServerSocketChannel.open();
            this.serverSockets.add(serverSocketChannel);
            serverSocketChannel.socket().bind(new InetSocketAddress(0));
            n = serverSocketChannel.socket().getLocalPort();
        }
        catch (Exception exception) {
            throw UncheckedException.throwAsUncheckedException((Throwable)exception);
        }
        Object obj = this.idGenerator.generateId();
        List<InetAddress> list = bl ? this.remoteAddresses : this.localAddresses;
        MultiChoiceAddress multiChoiceAddress = new MultiChoiceAddress(obj, n, list);
        LOGGER.debug("Listening on {}.", (Object)multiChoiceAddress);
        this.executor.execute(new Receiver(serverSocketChannel, action, bl));
        return multiChoiceAddress;
    }

    @Override
    public void requestStop() {
        new CompositeStoppable(new Object[0]).add(this.serverSockets).stop();
    }

    public void stop() {
        this.requestStop();
        this.executor.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Receiver
    implements Runnable {
        private final ServerSocketChannel serverSocket;
        private final Action<ConnectEvent<Connection<T>>> action;
        private final boolean allowRemote;

        public Receiver(ServerSocketChannel serverSocketChannel, Action<ConnectEvent<Connection<T>>> action, boolean bl) {
            this.serverSocket = serverSocketChannel;
            this.action = action;
            this.allowRemote = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        SocketChannel socketChannel = this.serverSocket.accept();
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
                        if (!this.allowRemote && !TcpIncomingConnector.this.localAddresses.contains(inetSocketAddress.getAddress())) {
                            LOGGER.error("Cannot accept connection from remote address {}.", (Object)inetSocketAddress.getAddress());
                            socketChannel.close();
                            continue;
                        }
                        SocketConnection socketConnection = new SocketConnection(socketChannel, TcpIncomingConnector.this.serializer);
                        Address address = socketConnection.getLocalAddress();
                        Address address2 = socketConnection.getRemoteAddress();
                        LOGGER.debug("Accepted connection from {} to {}.", (Object)address2, (Object)address);
                        this.action.execute(new ConnectEvent(socketConnection, address, address2));
                    }
                }
                catch (ClosedChannelException closedChannelException) {
                }
                catch (Exception exception) {
                    LOGGER.error("Could not accept remote connection.", (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                new CompositeStoppable(new Object[]{this.serverSocket}).stop();
                TcpIncomingConnector.this.serverSockets.remove(this.serverSocket);
                throw throwable;
            }
            new CompositeStoppable(new Object[]{this.serverSocket}).stop();
            TcpIncomingConnector.this.serverSockets.remove(this.serverSocket);
        }
    }
}

