/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.gradle.messaging.remote.internal.inet.InetEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketInetAddress
implements InetEndpoint {
    private final InetAddress address;
    private final int port;

    public SocketInetAddress(InetAddress inetAddress, int n) {
        this.address = inetAddress;
        this.port = n;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s:%s", this.address, this.port);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SocketInetAddress socketInetAddress = (SocketInetAddress)object;
        return socketInetAddress.address.equals(this.address) && socketInetAddress.port == this.port;
    }

    public int hashCode() {
        return this.address.hashCode() ^ this.port;
    }

    @Override
    public List<InetAddress> getCandidates() {
        return Collections.singletonList(this.address);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

