/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import com.google.common.base.Objects;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.CompositeStoppable;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.MessageIOException;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.SocketInetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketConnection<T>
implements Connection<T> {
    private final SocketChannel socket;
    private final SocketInetAddress localAddress;
    private final SocketInetAddress remoteAddress;
    private final MessageSerializer<T> serializer;
    private final DataInputStream instr;
    private final DataOutputStream outstr;

    public SocketConnection(SocketChannel socketChannel, MessageSerializer<T> messageSerializer) {
        this.socket = socketChannel;
        this.serializer = messageSerializer;
        try {
            socketChannel.configureBlocking(false);
            this.outstr = new DataOutputStream(new SocketOutputStream(socketChannel));
            this.instr = new DataInputStream(new SocketInputStream(socketChannel));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketChannel.socket().getLocalSocketAddress();
        this.localAddress = new SocketInetAddress(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        InetSocketAddress inetSocketAddress2 = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        this.remoteAddress = new SocketInetAddress(inetSocketAddress2.getAddress(), inetSocketAddress2.getPort());
    }

    public String toString() {
        return String.format("socket connection at %s with %s", this.localAddress, this.remoteAddress);
    }

    public Address getLocalAddress() {
        return this.localAddress;
    }

    public Address getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public T receive() {
        try {
            return this.serializer.read(this.instr, this.localAddress, this.remoteAddress);
        }
        catch (Exception exception) {
            if (this.isEndOfStream(exception)) {
                return null;
            }
            throw new MessageIOException(String.format("Could not read message from '%s'.", this.remoteAddress), exception);
        }
    }

    private boolean isEndOfStream(Exception exception) {
        if (exception instanceof EOFException) {
            return true;
        }
        if (exception instanceof IOException) {
            if (Objects.equal((Object)exception.getMessage(), (Object)"An existing connection was forcibly closed by the remote host")) {
                return true;
            }
            if (Objects.equal((Object)exception.getMessage(), (Object)"An established connection was aborted by the software in your host machine")) {
                return true;
            }
            if (Objects.equal((Object)exception.getMessage(), (Object)"Connection reset by peer")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispatch(T t) {
        try {
            this.serializer.write(t, this.outstr);
            this.outstr.flush();
        }
        catch (Exception exception) {
            throw new MessageIOException(String.format("Could not write message %s to '%s'.", t, this.remoteAddress), exception);
        }
    }

    @Override
    public void requestStop() {
        new CompositeStoppable(new Object[]{this.instr}).stop();
    }

    public void stop() {
        new CompositeStoppable(new Object[]{this.instr, this.outstr, this.socket}).stop();
    }

    private static class SocketOutputStream
    extends OutputStream {
        private final Selector selector;
        private final SocketChannel socket;
        private final ByteBuffer buffer;
        private final byte[] writeBuffer = new byte[1];

        public SocketOutputStream(SocketChannel socketChannel) throws IOException {
            this.socket = socketChannel;
            this.selector = Selector.open();
            socketChannel.register(this.selector, 4);
            this.buffer = ByteBuffer.allocateDirect(4096);
        }

        public void write(int n) throws IOException {
            this.writeBuffer[0] = (byte)n;
            this.write(this.writeBuffer);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n2;
            int n4 = n;
            while (n3 > 0) {
                int n5 = Math.min(n3, this.buffer.remaining());
                if (n5 > 0) {
                    this.buffer.put(byArray, n4, n5);
                    n3 -= n5;
                    n4 += n5;
                }
                if (this.buffer.remaining() != 0) continue;
                this.flush();
            }
        }

        public void flush() throws IOException {
            this.buffer.flip();
            while (this.buffer.remaining() > 0) {
                this.selector.select();
                if (!this.selector.isOpen()) {
                    throw new EOFException();
                }
                this.socket.write(this.buffer);
            }
            this.buffer.clear();
        }

        public void close() throws IOException {
            this.selector.close();
        }
    }

    private static class SocketInputStream
    extends InputStream {
        private final Selector selector;
        private final ByteBuffer buffer;
        private final SocketChannel socket;
        private final byte[] readBuffer = new byte[1];

        public SocketInputStream(SocketChannel socketChannel) throws IOException {
            this.socket = socketChannel;
            this.selector = Selector.open();
            socketChannel.register(this.selector, 1);
            this.buffer = ByteBuffer.allocateDirect(4096);
            this.buffer.limit(0);
        }

        public int read() throws IOException {
            int n = this.read(this.readBuffer, 0, 1);
            if (n <= 0) {
                return n;
            }
            return this.readBuffer[0];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            if (this.buffer.remaining() == 0) {
                try {
                    this.selector.select();
                }
                catch (ClosedSelectorException closedSelectorException) {
                    return -1;
                }
                if (!this.selector.isOpen()) {
                    return -1;
                }
                this.buffer.clear();
                n3 = this.socket.read(this.buffer);
                this.buffer.flip();
                if (n3 < 0) {
                    return -1;
                }
            }
            n3 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n3);
            return n3;
        }

        public void close() throws IOException {
            this.selector.close();
        }
    }
}

