/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.gradle.api.UncheckedIOException;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.MessageIOException;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.SocketInetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastConnection<T>
implements Connection<T> {
    private static final int MAX_MESSAGE_SIZE = 32768;
    private final MulticastSocket socket;
    private final SocketInetAddress address;
    private final MessageSerializer<T> serializer;
    private final SocketInetAddress localAddress;

    public MulticastConnection(SocketInetAddress socketInetAddress, MessageSerializer<T> messageSerializer) {
        this.address = socketInetAddress;
        this.serializer = messageSerializer;
        try {
            this.socket = new MulticastSocket(socketInetAddress.getPort());
            this.socket.joinGroup(socketInetAddress.getAddress());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        this.localAddress = new SocketInetAddress(this.socket.getInetAddress(), this.socket.getLocalPort());
    }

    public String toString() {
        return String.format("multicast connection %s", this.address);
    }

    @Override
    public void dispatch(T t) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.serializer.write(t, dataOutputStream);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.socket.send(new DatagramPacket(byArray, byArray.length, this.address.getAddress(), this.address.getPort()));
        }
        catch (Exception exception) {
            throw new MessageIOException(String.format("Could not write multi-cast message on %s.", this.address), exception);
        }
    }

    @Override
    public T receive() {
        try {
            byte[] byArray = new byte[32768];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, byArray.length);
            this.socket.receive(datagramPacket);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return this.serializer.read(dataInputStream, this.localAddress, new SocketInetAddress(datagramPacket.getAddress(), datagramPacket.getPort()));
        }
        catch (SocketException socketException) {
            return null;
        }
        catch (Exception exception) {
            throw new MessageIOException(String.format("Could not receive multi-cast message on %s", this.address), exception);
        }
    }

    @Override
    public void requestStop() {
        this.socket.close();
    }

    public void stop() {
        this.requestStop();
    }
}

