/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.gradle.messaging.remote.internal.inet.InetEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceAddress
implements InetEndpoint {
    private final Object canonicalAddress;
    private final int port;
    private final List<InetAddress> candidates;

    public MultiChoiceAddress(Object object, int n, List<InetAddress> list) {
        this.canonicalAddress = object;
        this.port = n;
        this.candidates = new ArrayList<InetAddress>(list);
    }

    @Override
    public String getDisplayName() {
        return String.format("[%s port:%s, addresses:%s]", this.canonicalAddress, this.port, this.candidates);
    }

    public Object getCanonicalAddress() {
        return this.canonicalAddress;
    }

    @Override
    public List<InetAddress> getCandidates() {
        return this.candidates;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiChoiceAddress multiChoiceAddress = (MultiChoiceAddress)object;
        return multiChoiceAddress.canonicalAddress.equals(this.canonicalAddress);
    }

    public int hashCode() {
        return this.canonicalAddress.hashCode();
    }

    public MultiChoiceAddress addAddresses(Iterable<InetAddress> iterable) {
        return new MultiChoiceAddress(this.canonicalAddress, this.port, Lists.newArrayList((Iterable)Iterables.concat(iterable, this.candidates)));
    }
}

