/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.gradle.api.GradleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressFactory {
    public List<InetAddress> findLocalAddresses() {
        try {
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!inetAddress.isLoopbackAddress()) continue;
                    arrayList.add(inetAddress);
                }
            }
            if (arrayList.isEmpty()) {
                arrayList.add(InetAddress.getByName(null));
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new GradleException("Could not determine the local IP addresses for this machine.", exception);
        }
    }

    public List<InetAddress> findRemoteAddresses() {
        try {
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    arrayList.add(inetAddress);
                }
            }
            if (arrayList.isEmpty()) {
                arrayList.add(InetAddress.getLocalHost());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new GradleException("Could not determine the remote IP addresses for this machine.", exception);
        }
    }
}

