/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.EndOfStreamEvent;
import org.gradle.messaging.remote.internal.protocol.MessageCredits;
import org.gradle.messaging.remote.internal.protocol.Request;
import org.gradle.messaging.remote.internal.protocol.WorkerStopping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerProtocol
implements Protocol<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerProtocol.class);
    private final Dispatch<Object> worker;
    private ProtocolContext<Message> context;

    public WorkerProtocol(Dispatch<Object> dispatch) {
        this.worker = dispatch;
    }

    @Override
    public void start(ProtocolContext<Message> protocolContext) {
        this.context = protocolContext;
        protocolContext.dispatchOutgoing(new MessageCredits(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleIncoming(Message message) {
        if (message instanceof EndOfStreamEvent) {
            LOGGER.debug("Received worker stopped: {}", (Object)message);
            this.context.stopped();
        } else if (message instanceof Request) {
            Request request = (Request)message;
            LOGGER.debug("Dispatching request to worker: {}", (Object)message);
            try {
                this.worker.dispatch(request.getPayload());
            }
            finally {
                this.context.dispatchOutgoing(new MessageCredits(1));
            }
        } else {
            throw new IllegalArgumentException(String.format("Unexpected incoming message received: %s", message));
        }
    }

    @Override
    public void handleOutgoing(Message message) {
        throw new IllegalArgumentException(String.format("Unexpected outgoing message dispatched: %s", message));
    }

    @Override
    public void stopRequested() {
        this.context.dispatchOutgoing(new WorkerStopping());
        this.context.stopLater();
    }
}

