/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import org.gradle.api.internal.Operation;
import org.gradle.api.internal.concurrent.Synchronizer;
import org.gradle.messaging.remote.internal.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedDispatch<T>
implements Connection<T> {
    private final Synchronizer sync = new Synchronizer();
    private final Connection<T> delegate;

    public SynchronizedDispatch(Connection<T> connection) {
        this.delegate = connection;
    }

    @Override
    public void requestStop() {
        this.delegate.requestStop();
    }

    @Override
    public void dispatch(final T t) {
        this.sync.synchronize(new Operation(){

            public void execute() {
                SynchronizedDispatch.this.delegate.dispatch(t);
            }
        });
    }

    @Override
    public T receive() {
        return this.delegate.receive();
    }

    public void stop() {
        this.delegate.stop();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

