/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.gradle.internal.Stoppable;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.gradle.messaging.dispatch.QueuingDispatch;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.EndOfStreamEvent;
import org.gradle.messaging.remote.internal.protocol.RoutableMessage;
import org.gradle.messaging.remote.internal.protocol.RouteAvailableMessage;
import org.gradle.messaging.remote.internal.protocol.RouteUnavailableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Router.class);
    private final AsyncDispatch<Runnable> workQueue;
    private final Group localConnections = new LocalGroup();
    private final Group remoteConnections = new RemoteGroup();
    private final DispatchFailureHandler<? super Message> failureHandler;

    public Router(Executor executor, DispatchFailureHandler<? super Message> dispatchFailureHandler) {
        this.failureHandler = dispatchFailureHandler;
        this.localConnections.peer = this.remoteConnections;
        this.remoteConnections.peer = this.localConnections;
        this.workQueue = new AsyncDispatch(executor);
        this.workQueue.dispatchTo(new Dispatch<Runnable>(){

            @Override
            public void dispatch(Runnable runnable) {
                runnable.run();
            }
        });
    }

    public AsyncConnection<Message> createLocalConnection() {
        return new Endpoint(this.localConnections);
    }

    public AsyncConnection<Message> createRemoteConnection() {
        return new Endpoint(this.remoteConnections);
    }

    public void stop() {
        this.workQueue.stop();
    }

    private static class RemoteGroup
    extends Group {
        private RemoteGroup() {
        }

        public void addEndpoint(Endpoint endpoint) {
            super.addEndpoint(endpoint);
            for (Route route : this.peer.routes.values()) {
                endpoint.dispatchIncoming((Message)((Object)route.announcement));
            }
        }

        public void addRoute(Route route) {
            super.addRoute(route);
            for (Route route2 : this.peer.routes.values()) {
                if (!route2.announcement.acceptIncoming(route.announcement)) continue;
                route.connectTo(route2);
            }
        }

        public Route removeRoute(Object object) {
            Route route = super.removeRoute(object);
            for (Route route2 : route.targets) {
                Message message = (Message)((Object)route.announcement.getUnavailableMessage());
                route2.destination.dispatchIncoming(message);
            }
            route.targets.clear();
            return route;
        }
    }

    private static class LocalGroup
    extends Group {
        private LocalGroup() {
        }

        public void addRoute(Route route) {
            super.addRoute(route);
            for (Object object : this.peer.endpoints) {
                ((Endpoint)object).dispatchIncoming((Message)((Object)route.announcement));
            }
            for (Object object : this.peer.routes.values()) {
                if (!route.announcement.acceptIncoming(((Route)object).announcement)) continue;
                ((Route)object).connectTo(route);
            }
        }

        public Route removeRoute(Object object) {
            Route route = super.removeRoute(object);
            Message message = (Message)((Object)route.announcement.getUnavailableMessage());
            for (Object object2 : this.peer.endpoints) {
                ((Endpoint)object2).dispatchIncoming(message);
            }
            for (Object object2 : this.peer.routes.values()) {
                ((Route)object2).targets.remove(route);
            }
            return route;
        }

        public void removeEndpoint(Endpoint endpoint) {
            super.removeEndpoint(endpoint);
            for (Route route : this.peer.routes.values()) {
                route.targets.removeAll(endpoint.routes);
            }
        }
    }

    private static class Group {
        private final Map<Object, Route> routes = new HashMap<Object, Route>();
        private final Set<Endpoint> endpoints = new HashSet<Endpoint>();
        Group peer;

        private Group() {
        }

        public void addEndpoint(Endpoint endpoint) {
            this.endpoints.add(endpoint);
        }

        public void addRoute(Route route) {
            this.routes.put(route.id, route);
        }

        public Route removeRoute(Object object) {
            return this.routes.remove(object);
        }

        public void send(Object object, Message message) {
            this.routes.get((Object)object).destination.dispatchIncoming(message);
        }

        public void removeEndpoint(Endpoint endpoint) {
            this.endpoints.remove(endpoint);
        }
    }

    private static class Route {
        final Object id;
        final RouteAvailableMessage announcement;
        final Endpoint destination;
        final Set<Route> targets = new HashSet<Route>();

        private Route(Object object, Endpoint endpoint, RouteAvailableMessage routeAvailableMessage) {
            this.id = object;
            this.destination = endpoint;
            this.announcement = routeAvailableMessage;
        }

        public void connectTo(Route route) {
            this.targets.add(route);
            route.destination.dispatchIncoming((Message)((Object)this.announcement));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Endpoint
    implements AsyncConnection<Message> {
        private QueuingDispatch<Message> handler = new QueuingDispatch();
        final Group owner;
        final Group peerGroup;
        final Set<Route> routes = new HashSet<Route>();

        protected Endpoint(Group group) {
            this.owner = group;
            this.peerGroup = group.peer;
            group.addEndpoint(this);
        }

        @Override
        public void dispatchTo(final Dispatch<? super Message> dispatch) {
            Router.this.workQueue.dispatch(new Runnable(){

                public void run() {
                    Endpoint.this.handler.dispatchTo(dispatch);
                }
            });
        }

        @Override
        public void dispatch(final Message message) {
            Router.this.workQueue.dispatch(new Runnable(){

                public void run() {
                    block7: {
                        try {
                            if (message instanceof RouteAvailableMessage) {
                                RouteAvailableMessage routeAvailableMessage = (RouteAvailableMessage)((Object)message);
                                LOGGER.debug("Received route available. Message: {}", (Object)routeAvailableMessage);
                                Route route = new Route(routeAvailableMessage.getId(), Endpoint.this, routeAvailableMessage);
                                Endpoint.this.routes.add(route);
                                Endpoint.this.owner.addRoute(route);
                                break block7;
                            }
                            if (message instanceof RouteUnavailableMessage) {
                                RouteUnavailableMessage routeUnavailableMessage = (RouteUnavailableMessage)((Object)message);
                                LOGGER.debug("Received route unavailable. Message: {}", (Object)routeUnavailableMessage);
                                Route route = Endpoint.this.owner.removeRoute(routeUnavailableMessage.getId());
                                Endpoint.this.routes.remove(route);
                                break block7;
                            }
                            if (message instanceof RoutableMessage) {
                                RoutableMessage routableMessage = (RoutableMessage)((Object)message);
                                Endpoint.this.peerGroup.send(routableMessage.getDestination(), message);
                                break block7;
                            }
                            if (message instanceof EndOfStreamEvent) {
                                for (Route route : Endpoint.this.routes) {
                                    LOGGER.debug("Removing route {} due to end of stream.", route.id);
                                    Endpoint.this.owner.removeRoute(route.id);
                                }
                                Endpoint.this.owner.removeEndpoint(Endpoint.this);
                                Endpoint.this.dispatchIncoming(message);
                                break block7;
                            }
                            throw new UnsupportedOperationException(String.format("Received message which cannot be routed: %s.", message));
                        }
                        catch (Throwable throwable) {
                            Router.this.failureHandler.dispatchFailed(message, throwable);
                        }
                    }
                }
            });
        }

        void dispatchIncoming(Message message) {
            this.handler.dispatch(message);
        }
    }
}

