/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.EndOfStreamEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDisconnectProtocol
implements Protocol<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDisconnectProtocol.class);
    private ProtocolContext<Message> context;
    private boolean stopping;
    private boolean outgoingStopped;
    private boolean finished;

    @Override
    public void start(ProtocolContext<Message> protocolContext) {
        this.context = protocolContext;
    }

    @Override
    public void handleIncoming(Message message) {
        this.context.dispatchIncoming(message);
    }

    @Override
    public void handleOutgoing(Message message) {
        if (message instanceof EndOfStreamEvent) {
            if (this.stopping) {
                this.context.stopped();
                return;
            }
            this.context.dispatchOutgoing(message);
            this.outgoingStopped = true;
            this.finished = true;
        } else if (!this.outgoingStopped) {
            this.context.dispatchOutgoing(message);
        } else {
            LOGGER.debug("Discarding outgoing message {} as output has been finished.", (Object)message);
        }
    }

    @Override
    public void stopRequested() {
        if (this.finished) {
            this.context.stopped();
            return;
        }
        if (!this.outgoingStopped) {
            this.context.dispatchOutgoing(new EndOfStreamEvent());
            this.outgoingStopped = true;
        }
        this.context.stopLater();
        this.stopping = true;
    }
}

