/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.remote.MessagingClient;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.AsyncConnectionAdapter;
import org.gradle.messaging.remote.internal.DefaultIncomingBroadcast;
import org.gradle.messaging.remote.internal.DefaultMessageSerializer;
import org.gradle.messaging.remote.internal.DefaultMessagingClient;
import org.gradle.messaging.remote.internal.DefaultMessagingServer;
import org.gradle.messaging.remote.internal.DefaultMultiChannelConnector;
import org.gradle.messaging.remote.internal.DefaultOutgoingBroadcast;
import org.gradle.messaging.remote.internal.IncomingBroadcast;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.MultiChannelConnector;
import org.gradle.messaging.remote.internal.OutgoingBroadcast;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;
import org.gradle.messaging.remote.internal.inet.MulticastConnection;
import org.gradle.messaging.remote.internal.inet.SocketInetAddress;
import org.gradle.messaging.remote.internal.inet.TcpIncomingConnector;
import org.gradle.messaging.remote.internal.inet.TcpOutgoingConnector;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.DiscoveryProtocolSerializer;
import org.gradle.util.IdGenerator;
import org.gradle.util.UUIDGenerator;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingServices
extends DefaultServiceRegistry
implements Stoppable {
    private final IdGenerator<UUID> idGenerator = new UUIDGenerator();
    private final ClassLoader messageClassLoader;
    private final String broadcastGroup;
    private final SocketInetAddress broadcastAddress;
    private DefaultMessagingClient messagingClient;
    private DefaultMultiChannelConnector multiChannelConnector;
    private TcpIncomingConnector<Message> incomingConnector;
    private DefaultExecutorFactory executorFactory;
    private DefaultMessagingServer messagingServer;
    private DefaultIncomingBroadcast incomingBroadcast;
    private AsyncConnectionAdapter<DiscoveryMessage> multicastConnection;
    private DefaultOutgoingBroadcast outgoingBroadcast;

    public MessagingServices(ClassLoader classLoader) {
        this(classLoader, "gradle");
    }

    public MessagingServices(ClassLoader classLoader, String string) {
        this(classLoader, string, MessagingServices.defaultBroadcastAddress());
    }

    public MessagingServices(ClassLoader classLoader, String string, SocketInetAddress socketInetAddress) {
        this.messageClassLoader = classLoader;
        this.broadcastGroup = string;
        this.broadcastAddress = socketInetAddress;
    }

    private static SocketInetAddress defaultBroadcastAddress() {
        try {
            return new SocketInetAddress(InetAddress.getByName("233.253.17.122"), 7912);
        }
        catch (UnknownHostException unknownHostException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)unknownHostException);
        }
    }

    private static String determineNodeName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = new InetAddressFactory().findRemoteAddresses().get(0).toString();
        }
        return String.format("%s@%s", System.getProperty("user.name"), string);
    }

    public void stop() {
        this.close();
    }

    public void close() {
        CompositeStoppable compositeStoppable = new CompositeStoppable(new Object[0]);
        compositeStoppable.add(new Object[]{this.incomingConnector});
        compositeStoppable.add(new Object[]{this.messagingClient});
        compositeStoppable.add(new Object[]{this.messagingServer});
        compositeStoppable.add(new Object[]{this.multiChannelConnector});
        compositeStoppable.add(new Object[]{this.outgoingBroadcast});
        compositeStoppable.add(new Object[]{this.incomingBroadcast});
        compositeStoppable.add(new Object[]{this.multicastConnection});
        compositeStoppable.add(new Object[]{this.executorFactory});
        compositeStoppable.stop();
    }

    protected MessageOriginator createMessageOriginator() {
        return new MessageOriginator(this.idGenerator.generateId(), MessagingServices.determineNodeName());
    }

    protected ExecutorFactory createExecutorFactory() {
        this.executorFactory = new DefaultExecutorFactory();
        return this.executorFactory;
    }

    protected OutgoingConnector<Message> createOutgoingConnector() {
        return new TcpOutgoingConnector<Message>(new DefaultMessageSerializer(this.messageClassLoader));
    }

    protected IncomingConnector<Message> createIncomingConnector() {
        this.incomingConnector = new TcpIncomingConnector((ExecutorFactory)this.get(ExecutorFactory.class), new DefaultMessageSerializer(this.messageClassLoader), new InetAddressFactory(), this.idGenerator);
        return this.incomingConnector;
    }

    protected MultiChannelConnector createMultiChannelConnector() {
        this.multiChannelConnector = new DefaultMultiChannelConnector((OutgoingConnector)this.get(OutgoingConnector.class), (IncomingConnector)this.get(IncomingConnector.class), (ExecutorFactory)this.get(ExecutorFactory.class), this.messageClassLoader);
        return this.multiChannelConnector;
    }

    protected MessagingClient createMessagingClient() {
        this.messagingClient = new DefaultMessagingClient((MultiChannelConnector)this.get(MultiChannelConnector.class), this.messageClassLoader);
        return this.messagingClient;
    }

    protected MessagingServer createMessagingServer() {
        this.messagingServer = new DefaultMessagingServer((MultiChannelConnector)this.get(MultiChannelConnector.class), this.messageClassLoader);
        return this.messagingServer;
    }

    protected IncomingBroadcast createIncomingBroadcast() {
        this.incomingBroadcast = new DefaultIncomingBroadcast((MessageOriginator)this.get(MessageOriginator.class), this.broadcastGroup, (AsyncConnection)this.get(AsyncConnection.class), (IncomingConnector)this.get(IncomingConnector.class), (ExecutorFactory)this.get(ExecutorFactory.class), this.idGenerator, this.messageClassLoader);
        return this.incomingBroadcast;
    }

    protected OutgoingBroadcast createOutgoingBroadcast() {
        this.outgoingBroadcast = new DefaultOutgoingBroadcast((MessageOriginator)this.get(MessageOriginator.class), this.broadcastGroup, (AsyncConnection)this.get(AsyncConnection.class), (OutgoingConnector)this.get(OutgoingConnector.class), (ExecutorFactory)this.get(ExecutorFactory.class), this.idGenerator, this.messageClassLoader);
        return this.outgoingBroadcast;
    }

    protected AsyncConnection<DiscoveryMessage> createMulticastConnection() {
        MulticastConnection<DiscoveryMessage> multicastConnection = new MulticastConnection<DiscoveryMessage>(this.broadcastAddress, new DiscoveryProtocolSerializer());
        this.multicastConnection = new AsyncConnectionAdapter<DiscoveryMessage>(multicastConnection, new DiscardingFailureHandler(LoggerFactory.getLogger(MulticastConnection.class)), (ExecutorFactory)this.get(ExecutorFactory.class), new Protocol[0]);
        return this.multicastConnection;
    }
}

