/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.CompositeStoppable;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.AsyncConnectionAdapter;
import org.gradle.messaging.remote.internal.BroadcastSendProtocol;
import org.gradle.messaging.remote.internal.BufferingProtocol;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DelegatingConnection;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MethodInvocationMarshallingDispatch;
import org.gradle.messaging.remote.internal.MethodInvocationUnmarshallingDispatch;
import org.gradle.messaging.remote.internal.OutgoingMultiplex;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolStack;
import org.gradle.messaging.remote.internal.ReceiveProtocol;
import org.gradle.messaging.remote.internal.RemoteDisconnectProtocol;
import org.gradle.messaging.remote.internal.Router;
import org.gradle.messaging.remote.internal.SendProtocol;
import org.gradle.messaging.remote.internal.UnicastSendProtocol;
import org.gradle.messaging.remote.internal.WorkerProtocol;
import org.gradle.messaging.remote.internal.protocol.EndOfStreamEvent;
import org.gradle.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHub
implements AsyncStoppable {
    private final Lock lock = new ReentrantLock();
    private final CompositeStoppable executors = new CompositeStoppable(new Object[0]);
    private final CompositeStoppable connections = new CompositeStoppable(new Object[0]);
    private final Collection<ProtocolStack<Message>> handlers = new ArrayList<ProtocolStack<Message>>();
    private final Collection<ProtocolStack<Message>> workers = new ArrayList<ProtocolStack<Message>>();
    private final Map<String, ProtocolStack<Message>> outgoingUnicasts = new HashMap<String, ProtocolStack<Message>>();
    private final Map<String, ProtocolStack<Message>> outgoingBroadcasts = new HashMap<String, ProtocolStack<Message>>();
    private final DispatchFailureHandler<Object> failureHandler;
    private final Router router;
    private final String displayName;
    private final String nodeName;
    private final ExecutorFactory executorFactory;
    private final IdGenerator<?> idGenerator;
    private final ClassLoader messagingClassLoader;
    private final StoppableExecutor incomingExecutor;

    public MessageHub(String string, String string2, ExecutorFactory executorFactory, IdGenerator<?> idGenerator, ClassLoader classLoader) {
        this.displayName = string;
        this.nodeName = string2;
        this.executorFactory = executorFactory;
        this.idGenerator = idGenerator;
        this.messagingClassLoader = classLoader;
        this.failureHandler = new DiscardingFailureHandler<Object>(LoggerFactory.getLogger(MessageHub.class));
        StoppableExecutor stoppableExecutor = executorFactory.create(string + " message router");
        this.executors.add(new Object[]{stoppableExecutor});
        this.router = new Router(stoppableExecutor, this.failureHandler);
        this.incomingExecutor = executorFactory.create(string + " worker");
        this.executors.add(new Object[]{this.incomingExecutor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection<Message> connection) {
        this.lock.lock();
        try {
            EndOfStreamConnection endOfStreamConnection = new EndOfStreamConnection(connection);
            AsyncConnectionAdapter<Object> asyncConnectionAdapter = new AsyncConnectionAdapter<Object>(endOfStreamConnection, this.failureHandler, this.executorFactory, new RemoteDisconnectProtocol());
            this.connections.add(new Object[]{asyncConnectionAdapter});
            AsyncConnection<Message> asyncConnection = this.router.createRemoteConnection();
            asyncConnection.dispatchTo(new MethodInvocationMarshallingDispatch(asyncConnectionAdapter));
            asyncConnectionAdapter.dispatchTo(new MethodInvocationUnmarshallingDispatch(asyncConnection, this.messagingClassLoader));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatch<Object> addUnicastOutgoing(String string) {
        this.lock.lock();
        try {
            Object object;
            ProtocolStack<Object> protocolStack = this.outgoingUnicasts.get(string);
            if (protocolStack == null) {
                object = new UnicastSendProtocol();
                SendProtocol sendProtocol = new SendProtocol(this.idGenerator.generateId(), this.nodeName, string);
                StoppableExecutor stoppableExecutor = this.executorFactory.create(this.displayName + " outgoing " + string);
                this.executors.add(new Object[]{stoppableExecutor});
                protocolStack = new ProtocolStack<Object>(stoppableExecutor, this.failureHandler, this.failureHandler, new Protocol[]{object, sendProtocol});
                this.outgoingUnicasts.put(string, protocolStack);
                AsyncConnection<Message> asyncConnection = this.router.createLocalConnection();
                protocolStack.getBottom().dispatchTo(asyncConnection);
                asyncConnection.dispatchTo(protocolStack.getBottom());
            }
            object = new OutgoingMultiplex(string, protocolStack.getTop());
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatch<Object> addMulticastOutgoing(String string) {
        this.lock.lock();
        try {
            Object object;
            ProtocolStack<Object> protocolStack = this.outgoingBroadcasts.get(string);
            if (protocolStack == null) {
                object = new BroadcastSendProtocol();
                SendProtocol sendProtocol = new SendProtocol(this.idGenerator.generateId(), this.nodeName, string);
                StoppableExecutor stoppableExecutor = this.executorFactory.create(this.displayName + " outgoing broadcast " + string);
                this.executors.add(new Object[]{stoppableExecutor});
                protocolStack = new ProtocolStack<Object>(stoppableExecutor, this.failureHandler, this.failureHandler, new Protocol[]{object, sendProtocol});
                this.outgoingBroadcasts.put(string, protocolStack);
                AsyncConnection<Message> asyncConnection = this.router.createLocalConnection();
                protocolStack.getBottom().dispatchTo(asyncConnection);
                asyncConnection.dispatchTo(protocolStack.getBottom());
            }
            object = new OutgoingMultiplex(string, protocolStack.getTop());
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncoming(String string, Dispatch<Object> dispatch) {
        this.lock.lock();
        try {
            Object obj = this.idGenerator.generateId();
            WorkerProtocol workerProtocol = new WorkerProtocol(dispatch);
            ReceiveProtocol receiveProtocol = new ReceiveProtocol(obj, this.nodeName, string);
            ProtocolStack<Object> protocolStack = new ProtocolStack<Object>(this.incomingExecutor, this.failureHandler, this.failureHandler, workerProtocol);
            this.workers.add(protocolStack);
            ProtocolStack<Object> protocolStack2 = new ProtocolStack<Object>(this.incomingExecutor, this.failureHandler, this.failureHandler, new BufferingProtocol(200), receiveProtocol);
            this.handlers.add(protocolStack2);
            protocolStack.getBottom().dispatchTo(protocolStack2.getTop());
            protocolStack2.getTop().dispatchTo(protocolStack.getBottom());
            AsyncConnection<Message> asyncConnection = this.router.createLocalConnection();
            protocolStack2.getBottom().dispatchTo(asyncConnection);
            asyncConnection.dispatchTo(protocolStack2.getBottom());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this.lock.lock();
        try {
            for (ProtocolStack<Message> protocolStack : this.outgoingUnicasts.values()) {
                protocolStack.requestStop();
            }
            for (ProtocolStack<Message> protocolStack : this.outgoingBroadcasts.values()) {
                protocolStack.requestStop();
            }
            for (ProtocolStack<Message> protocolStack : this.workers) {
                protocolStack.requestStop();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.requestStop();
        CompositeStoppable compositeStoppable = new CompositeStoppable(new Object[0]);
        this.lock.lock();
        try {
            compositeStoppable.add(this.outgoingUnicasts.values());
            compositeStoppable.add(this.outgoingBroadcasts.values());
            compositeStoppable.add(this.workers);
            compositeStoppable.add(this.handlers);
            compositeStoppable.add(new Object[]{this.connections});
            compositeStoppable.add(new Object[]{this.router});
            compositeStoppable.add(new Object[]{this.executors});
        }
        finally {
            this.outgoingUnicasts.clear();
            this.outgoingBroadcasts.clear();
            this.workers.clear();
            this.handlers.clear();
            this.lock.unlock();
        }
        compositeStoppable.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndOfStreamConnection
    extends DelegatingConnection<Message> {
        private static final Logger LOGGER = LoggerFactory.getLogger(EndOfStreamConnection.class);
        boolean incomingFinished;

        private EndOfStreamConnection(Connection<Message> connection) {
            super(connection);
        }

        @Override
        public Message receive() {
            Message message;
            if (this.incomingFinished) {
                return null;
            }
            try {
                message = (Message)super.receive();
            }
            catch (Throwable throwable) {
                LOGGER.error("Could not receive message from connection. Discarding connection.", throwable);
                message = null;
            }
            if (message instanceof EndOfStreamEvent) {
                this.incomingFinished = true;
            } else if (message == null) {
                this.incomingFinished = true;
                message = new EndOfStreamEvent();
            }
            return message;
        }
    }
}

