/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.remote.internal.PlaceholderException;
import org.gradle.util.ClassLoaderObjectInputStream;

public abstract class Message
implements Serializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Object object, OutputStream outputStream) throws IOException {
        ExceptionReplacingObjectOutputStream exceptionReplacingObjectOutputStream = new ExceptionReplacingObjectOutputStream(outputStream);
        try {
            exceptionReplacingObjectOutputStream.writeObject(object);
        }
        finally {
            exceptionReplacingObjectOutputStream.flush();
        }
    }

    public static Object receive(InputStream inputStream, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ExceptionReplacingObjectInputStream exceptionReplacingObjectInputStream = new ExceptionReplacingObjectInputStream(inputStream, classLoader);
        return exceptionReplacingObjectInputStream.readObject();
    }

    private static class ExceptionReplacingObjectInputStream
    extends ClassLoaderObjectInputStream {
        public ExceptionReplacingObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream, classLoader);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object object) throws IOException {
            if (object instanceof TopLevelExceptionPlaceholder) {
                return ((ExceptionPlaceholder)object).read(this.getClassLoader());
            }
            return object;
        }
    }

    private static class ExceptionReplacingObjectOutputStream
    extends ObjectOutputStream {
        public ExceptionReplacingObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object object) throws IOException {
            if (object instanceof Throwable) {
                return new TopLevelExceptionPlaceholder((Throwable)object);
            }
            return object;
        }
    }

    private static class TopLevelExceptionPlaceholder
    extends ExceptionPlaceholder {
        private TopLevelExceptionPlaceholder(Throwable throwable) throws IOException {
            super(throwable);
        }
    }

    private static class CausePlaceholder
    implements Serializable {
        private CausePlaceholder() {
        }
    }

    private static class ExceptionPlaceholder
    implements Serializable {
        private byte[] serializedException;
        private String type;
        private String message;
        private ExceptionPlaceholder cause;
        private StackTraceElement[] stackTrace;

        public ExceptionPlaceholder(final Throwable throwable) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ExceptionReplacingObjectOutputStream exceptionReplacingObjectOutputStream = new ExceptionReplacingObjectOutputStream(byteArrayOutputStream){

                protected Object replaceObject(Object object) throws IOException {
                    if (object == throwable) {
                        return throwable;
                    }
                    if (object == throwable.getCause()) {
                        return new CausePlaceholder();
                    }
                    return super.replaceObject(object);
                }
            };
            try {
                exceptionReplacingObjectOutputStream.writeObject(throwable);
                exceptionReplacingObjectOutputStream.close();
                this.serializedException = byteArrayOutputStream.toByteArray();
            }
            catch (NotSerializableException notSerializableException) {
                // empty catch block
            }
            this.type = throwable.getClass().getName();
            this.message = throwable.getMessage();
            if (throwable.getCause() != null) {
                this.cause = new ExceptionPlaceholder(throwable.getCause());
            }
            this.stackTrace = throwable.getStackTrace();
        }

        public Throwable read(ClassLoader classLoader) throws IOException {
            final Throwable throwable = this.getCause(classLoader);
            Throwable throwable2 = null;
            if (this.serializedException != null) {
                try {
                    ExceptionReplacingObjectInputStream exceptionReplacingObjectInputStream = new ExceptionReplacingObjectInputStream(new ByteArrayInputStream(this.serializedException), classLoader){

                        protected Object resolveObject(Object object) throws IOException {
                            if (object instanceof CausePlaceholder) {
                                return throwable;
                            }
                            return super.resolveObject(object);
                        }
                    };
                    throwable2 = (Throwable)exceptionReplacingObjectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InvalidClassException invalidClassException) {
                    try {
                        Constructor<?> constructor = classLoader.loadClass(this.type).getConstructor(String.class);
                        throwable2 = (Throwable)constructor.newInstance(this.message);
                        throwable2.initCause(throwable);
                        throwable2.setStackTrace(this.stackTrace);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Throwable throwable3) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)throwable3);
                    }
                }
            }
            if (throwable2 == null) {
                throwable2 = new PlaceholderException(this.type, this.message, throwable);
                throwable2.setStackTrace(this.stackTrace);
            }
            return throwable2;
        }

        private Throwable getCause(ClassLoader classLoader) throws IOException {
            return this.cause != null ? this.cause.read(classLoader) : null;
        }
    }
}

