/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.remote.internal.MultiChannelConnection;
import org.gradle.messaging.remote.internal.TypeCastDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingMethodInvocationHandler {
    private final MultiChannelConnection<Object> connection;
    private final Set<Class<?>> classes = new CopyOnWriteArraySet();

    public IncomingMethodInvocationHandler(MultiChannelConnection<Object> multiChannelConnection) {
        this.connection = multiChannelConnection;
    }

    public <T> void addIncoming(Class<T> clazz, T t) {
        this.addIncoming((Class<?>)clazz, new ReflectionDispatch(t));
    }

    public void addIncoming(Class<?> clazz, Dispatch<? super MethodInvocation> dispatch) {
        HashSet hashSet = new HashSet();
        this.addInterfaces(clazz, hashSet);
        for (Class clazz2 : hashSet) {
            if (!this.classes.add(clazz2)) {
                throw new IllegalArgumentException(String.format("A handler has already been added for type '%s'.", clazz2.getName()));
            }
            this.connection.addIncomingChannel(clazz2.getName(), new TypeCastDispatch(MethodInvocation.class, dispatch));
        }
    }

    private void addInterfaces(Class<?> clazz, Set<Class<?>> set) {
        set.add(clazz);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.addInterfaces(clazz2, set);
        }
    }
}

