/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import org.gradle.internal.UncheckedException;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.CompositeAddress;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.protocol.ConnectRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandshakeOutgoingConnector
implements OutgoingConnector<Message> {
    private final OutgoingConnector<Message> connector;

    public HandshakeOutgoingConnector(OutgoingConnector<Message> outgoingConnector) {
        this.connector = outgoingConnector;
    }

    @Override
    public Connection<Message> connect(Address address) {
        if (!(address instanceof CompositeAddress)) {
            throw new IllegalArgumentException(String.format("Cannot create a connection to address of unknown type: %s.", address));
        }
        CompositeAddress compositeAddress = (CompositeAddress)address;
        Address address2 = compositeAddress.getAddress();
        Connection<Message> connection = this.connector.connect(address2);
        try {
            connection.dispatch(new ConnectRequest(address));
        }
        catch (Throwable throwable) {
            connection.stop();
            throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
        }
        return connection;
    }
}

