/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.gradle.api.Action;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.internal.CompositeAddress;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.ConnectRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandshakeIncomingConnector
implements IncomingConnector<Message> {
    private final IncomingConnector<Message> connector;
    private final Executor executor;
    private final Object lock = new Object();
    private Address localAddress;
    private long nextId;
    private final Map<Address, Action<ConnectEvent<Connection<Message>>>> pendingActions = new HashMap<Address, Action<ConnectEvent<Connection<Message>>>>();

    public HandshakeIncomingConnector(IncomingConnector<Message> incomingConnector, Executor executor) {
        this.connector = incomingConnector;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address accept(Action<ConnectEvent<Connection<Message>>> action, boolean bl) {
        assert (!bl);
        Object object = this.lock;
        synchronized (object) {
            if (this.localAddress == null) {
                this.localAddress = this.connector.accept(this.handShakeAction(), false);
            }
            CompositeAddress compositeAddress = new CompositeAddress(this.localAddress, this.nextId++);
            this.pendingActions.put(compositeAddress, action);
            return compositeAddress;
        }
    }

    private Action<ConnectEvent<Connection<Message>>> handShakeAction() {
        return new Action<ConnectEvent<Connection<Message>>>(){

            @Override
            public void execute(final ConnectEvent<Connection<Message>> connectEvent) {
                HandshakeIncomingConnector.this.executor.execute(new Runnable(){

                    public void run() {
                        HandshakeIncomingConnector.this.handshake(connectEvent);
                    }
                });
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(ConnectEvent<Connection<Message>> connectEvent) {
        Action<ConnectEvent<Connection<Message>>> action;
        Connection<Message> connection = connectEvent.getConnection();
        ConnectRequest connectRequest = (ConnectRequest)connection.receive();
        Address address = connectRequest.getDestinationAddress();
        Object object = this.lock;
        synchronized (object) {
            action = this.pendingActions.remove(address);
        }
        if (action == null) {
            throw new IllegalStateException(String.format("Request to connect received for unknown address '%s'.", address));
        }
        action.execute(new ConnectEvent<Connection<Message>>(connection, address, connectEvent.getRemoteAddress()));
    }
}

