/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.AsyncReceive;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.Receive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagerReceiveBuffer<T>
implements Receive<T>,
AsyncStoppable {
    private static final Logger LOGGER = Logging.getLogger(EagerReceiveBuffer.class);
    private static final int DEFAULT_BUFFER_SIZE = 200;
    private final Lock lock = new ReentrantLock();
    private final Condition notFullOrStop = this.lock.newCondition();
    private final Condition notEmptyOrNoReceivers = this.lock.newCondition();
    private final StoppableExecutor executor;
    private final int bufferSize;
    private final Collection<Receive<T>> receivers;
    private final Runnable onReceiversExhausted;
    private final CountDownLatch onReceiversExhaustedFinishedLatch = new CountDownLatch(1);
    private final AsyncReceive<T> asyncReceive;
    private final LinkedList<T> queue = new LinkedList();
    private boolean hasActiveReceivers = true;
    private State state = State.Init;

    private static <T> Collection<Receive<T>> toReceiveCollection(Receive<T> receive) {
        ArrayList<Receive<T>> arrayList = new ArrayList<Receive<T>>(1);
        arrayList.add(receive);
        return arrayList;
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, Receive<T> receive) {
        this(stoppableExecutor, 200, EagerReceiveBuffer.toReceiveCollection(receive), null);
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, Receive<T> receive, Runnable runnable) {
        this(stoppableExecutor, 200, EagerReceiveBuffer.toReceiveCollection(receive), runnable);
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, Collection<Receive<T>> collection) {
        this(stoppableExecutor, 200, collection, null);
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, Collection<Receive<T>> collection, Runnable runnable) {
        this(stoppableExecutor, 200, collection, runnable);
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, int n, Receive<T> receive) {
        this(stoppableExecutor, n, EagerReceiveBuffer.toReceiveCollection(receive), null);
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, int n, Receive<T> receive, Runnable runnable) {
        this(stoppableExecutor, n, EagerReceiveBuffer.toReceiveCollection(receive), runnable);
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, int n, Collection<Receive<T>> collection) {
        this(stoppableExecutor, n, collection, null);
    }

    public EagerReceiveBuffer(StoppableExecutor stoppableExecutor, final int n, Collection<Receive<T>> collection, final Runnable runnable) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("eager receive buffer created with no receivers");
        }
        if (n < 1) {
            throw new IllegalArgumentException("eager receive buffer size must be positive (value given: " + n + ")");
        }
        this.executor = stoppableExecutor;
        this.bufferSize = n;
        this.receivers = collection;
        this.onReceiversExhausted = runnable;
        Dispatch dispatch = new Dispatch<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatch(T t) {
                EagerReceiveBuffer.this.lock.lock();
                try {
                    while (EagerReceiveBuffer.this.queue.size() == n && EagerReceiveBuffer.this.state == State.Started) {
                        try {
                            EagerReceiveBuffer.this.notFullOrStop.await();
                        }
                        catch (InterruptedException interruptedException) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
                        }
                    }
                    EagerReceiveBuffer.this.queue.add(t);
                    EagerReceiveBuffer.this.notEmptyOrNoReceivers.signalAll();
                }
                finally {
                    EagerReceiveBuffer.this.lock.unlock();
                }
            }
        };
        this.asyncReceive = new AsyncReceive(stoppableExecutor, dispatch, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EagerReceiveBuffer.this.lock.lock();
                try {
                    EagerReceiveBuffer.this.hasActiveReceivers = false;
                    if (runnable != null) {
                        runnable.run();
                    }
                    EagerReceiveBuffer.this.notEmptyOrNoReceivers.signalAll();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                finally {
                    EagerReceiveBuffer.this.lock.unlock();
                    EagerReceiveBuffer.this.onReceiversExhaustedFinishedLatch.countDown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (this.state != State.Init) {
                throw new IllegalStateException("this eager receive buffer has already been started");
            }
            this.state = State.Started;
            for (Receive<T> receive : this.receivers) {
                this.asyncReceive.receiveFrom(receive);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T receive() {
        this.lock.lock();
        try {
            while (this.queue.isEmpty() && this.hasActiveReceivers) {
                try {
                    this.notEmptyOrNoReceivers.await();
                }
                catch (InterruptedException interruptedException) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
                }
            }
            if (this.queue.isEmpty()) {
                assert (!this.hasActiveReceivers);
                T t = null;
                return t;
            }
            T t = this.queue.poll();
            assert (t != null);
            this.notFullOrStop.signalAll();
            T t2 = t;
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doRequestStop() {
        this.asyncReceive.requestStop();
        if (this.hasActiveReceivers) {
            this.setState(State.Stopping);
        } else {
            this.setState(State.Stopped);
        }
    }

    private void setState(State state) {
        this.state = state;
        this.notFullOrStop.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.onReceiversExhaustedFinishedLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
        }
        this.lock.lock();
        try {
            this.asyncReceive.stop();
            this.setState(State.Stopped);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Init,
        Started,
        Stopping,
        Stopped;

    }
}

