/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DelegatingConnection;
import org.gradle.messaging.remote.internal.DisconnectAwareConnection;
import org.gradle.messaging.remote.internal.EagerReceiveBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisconnectAwareConnectionDecorator<T>
extends DelegatingConnection<T>
implements DisconnectAwareConnection<T> {
    private static final Logger LOGGER = Logging.getLogger(DisconnectAwareConnectionDecorator.class);
    private static final int DEFAULT_BUFFER_SIZE = 200;
    private final Lock actionLock = new ReentrantLock();
    private final CountDownLatch actionSetLatch = new CountDownLatch(1);
    private final EagerReceiveBuffer<T> receiveBuffer;
    private Runnable disconnectAction;
    private volatile boolean stopped;

    public DisconnectAwareConnectionDecorator(Connection<T> connection, StoppableExecutor stoppableExecutor) {
        this(connection, stoppableExecutor, 200);
    }

    public DisconnectAwareConnectionDecorator(Connection<T> connection, StoppableExecutor stoppableExecutor, int n) {
        super(connection);
        this.receiveBuffer = new EagerReceiveBuffer<T>(stoppableExecutor, n, connection, new Runnable(){

            public void run() {
                DisconnectAwareConnectionDecorator.this.invokeDisconnectAction();
            }
        });
        this.receiveBuffer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable onDisconnect(Runnable runnable) {
        this.actionLock.lock();
        try {
            Runnable runnable2 = runnable;
            this.disconnectAction = runnable;
            this.actionSetLatch.countDown();
            Runnable runnable3 = runnable2;
            return runnable3;
        }
        finally {
            this.actionLock.unlock();
        }
    }

    @Override
    public T receive() {
        return this.receiveBuffer.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeDisconnectAction() {
        block8: {
            if (!this.stopped) {
                try {
                    this.actionSetLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
                }
                this.actionLock.lock();
                try {
                    if (this.disconnectAction == null) break block8;
                    LOGGER.debug("about to invoke disconnection handler {}", this.disconnectAction);
                    try {
                        this.disconnectAction.run();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LOGGER.error("disconnection handler threw exception", exception);
                        throw UncheckedException.throwAsUncheckedException((Throwable)exception);
                    }
                    LOGGER.info("completed disconnection handler {}", this.disconnectAction);
                }
                finally {
                    this.actionLock.unlock();
                }
            }
        }
    }

    @Override
    public void requestStop() {
        this.stopped = true;
        this.onDisconnect(null);
        super.requestStop();
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.onDisconnect(null);
        super.stop();
        this.receiveBuffer.stop();
    }
}

