/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.ProxyDispatchAdapter;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.ChannelLookupProtocol;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.GroupMessageFilter;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageHub;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.OutgoingBroadcast;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.ProtocolStack;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.gradle.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOutgoingBroadcast
implements OutgoingBroadcast,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOutgoingBroadcast.class);
    private final MessageOriginator messageOriginator;
    private final String group;
    private final OutgoingConnector<Message> outgoingConnector;
    private final ProtocolStack<DiscoveryMessage> discoveryBroadcast;
    private final Lock lock = new ReentrantLock();
    private final StoppableExecutor executor;
    private final Set<String> channels = new HashSet<String>();
    private final Set<Address> connections = new HashSet<Address>();
    private final MessageHub hub;

    public DefaultOutgoingBroadcast(MessageOriginator messageOriginator, String string, AsyncConnection<DiscoveryMessage> asyncConnection, OutgoingConnector<Message> outgoingConnector, ExecutorFactory executorFactory, IdGenerator<?> idGenerator, ClassLoader classLoader) {
        this.messageOriginator = messageOriginator;
        this.group = string;
        this.outgoingConnector = outgoingConnector;
        DiscardingFailureHandler discardingFailureHandler = new DiscardingFailureHandler(LOGGER);
        this.hub = new MessageHub("outgoing broadcast", messageOriginator.getName(), executorFactory, idGenerator, classLoader);
        this.executor = executorFactory.create("broadcast lookup");
        this.discoveryBroadcast = new ProtocolStack(this.executor, discardingFailureHandler, discardingFailureHandler, new ChannelLookupProtocol());
        asyncConnection.dispatchTo(new GroupMessageFilter(string, this.discoveryBroadcast.getBottom()));
        this.discoveryBroadcast.getBottom().dispatchTo(asyncConnection);
        this.discoveryBroadcast.getTop().dispatchTo(new DiscoveryMessageDispatch());
        LOGGER.info("Created OutgoingBroadcast with {}", (Object)messageOriginator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T addOutgoing(Class<T> clazz) {
        String string = clazz.getName();
        this.lock.lock();
        try {
            if (this.channels.add(string)) {
                this.discoveryBroadcast.getTop().dispatch(new LookupRequest(this.messageOriginator, this.group, string));
            }
        }
        finally {
            this.lock.unlock();
        }
        return new ProxyDispatchAdapter<T>(this.hub.addMulticastOutgoing(string), clazz, new Class[0]).getSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CompositeStoppable compositeStoppable = new CompositeStoppable(new Object[0]);
        this.lock.lock();
        try {
            compositeStoppable.add(new Object[]{this.hub, this.discoveryBroadcast, this.executor});
        }
        finally {
            this.connections.clear();
            this.lock.unlock();
        }
        compositeStoppable.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiscoveryMessageDispatch
    implements Dispatch<DiscoveryMessage> {
        private DiscoveryMessageDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(DiscoveryMessage discoveryMessage) {
            if (discoveryMessage instanceof ChannelAvailable) {
                ChannelAvailable channelAvailable = (ChannelAvailable)discoveryMessage;
                Address address = channelAvailable.getAddress();
                DefaultOutgoingBroadcast.this.lock.lock();
                try {
                    if (!DefaultOutgoingBroadcast.this.channels.contains(channelAvailable.getChannel())) {
                        return;
                    }
                    if (DefaultOutgoingBroadcast.this.connections.contains(address)) {
                        return;
                    }
                    DefaultOutgoingBroadcast.this.connections.add(address);
                }
                finally {
                    DefaultOutgoingBroadcast.this.lock.unlock();
                }
                Connection<Message> connection = DefaultOutgoingBroadcast.this.outgoingConnector.connect(address);
                DefaultOutgoingBroadcast.this.hub.addConnection(connection);
            }
        }
    }
}

