/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.UUID;
import org.gradle.api.Action;
import org.gradle.internal.Stoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DefaultMultiChannelConnection;
import org.gradle.messaging.remote.internal.HandshakeIncomingConnector;
import org.gradle.messaging.remote.internal.HandshakeOutgoingConnector;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageHub;
import org.gradle.messaging.remote.internal.MultiChannelConnection;
import org.gradle.messaging.remote.internal.MultiChannelConnector;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.util.IdGenerator;
import org.gradle.util.UUIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiChannelConnector
implements MultiChannelConnector,
Stoppable {
    private final OutgoingConnector<Message> outgoingConnector;
    private final ExecutorFactory executorFactory;
    private final StoppableExecutor executorService;
    private final HandshakeIncomingConnector incomingConnector;
    private final IdGenerator<UUID> idGenerator = new UUIDGenerator();
    private final ClassLoader messagingClassLoader;

    public DefaultMultiChannelConnector(OutgoingConnector<Message> outgoingConnector, IncomingConnector<Message> incomingConnector, ExecutorFactory executorFactory, ClassLoader classLoader) {
        this.messagingClassLoader = classLoader;
        this.outgoingConnector = new HandshakeOutgoingConnector(outgoingConnector);
        this.executorFactory = executorFactory;
        this.executorService = executorFactory.create("Incoming Connection Handler");
        this.incomingConnector = new HandshakeIncomingConnector(incomingConnector, this.executorService);
    }

    public void stop() {
        this.executorService.stop();
    }

    @Override
    public Address accept(final Action<ConnectEvent<MultiChannelConnection<Object>>> action) {
        Action<ConnectEvent<Connection<Message>>> action2 = new Action<ConnectEvent<Connection<Message>>>(){

            @Override
            public void execute(ConnectEvent<Connection<Message>> connectEvent) {
                DefaultMultiChannelConnector.this.finishConnect(connectEvent, action);
            }
        };
        return this.incomingConnector.accept(action2, false);
    }

    private void finishConnect(ConnectEvent<Connection<Message>> connectEvent, Action<ConnectEvent<MultiChannelConnection<Object>>> action) {
        Address address = connectEvent.getLocalAddress();
        Address address2 = connectEvent.getRemoteAddress();
        MessageHub messageHub = new MessageHub(String.format("Incoming Connection %s", address), "message server", this.executorFactory, this.idGenerator, this.messagingClassLoader);
        DefaultMultiChannelConnection defaultMultiChannelConnection = new DefaultMultiChannelConnection(messageHub, connectEvent.getConnection(), address, address2);
        action.execute(new ConnectEvent<DefaultMultiChannelConnection>(defaultMultiChannelConnection, address, address2));
    }

    @Override
    public MultiChannelConnection<Object> connect(Address address) {
        Connection<Message> connection = this.outgoingConnector.connect(address);
        MessageHub messageHub = new MessageHub(String.format("Outgoing Connection %s", address), "message client", this.executorFactory, this.idGenerator, this.messagingClassLoader);
        return new DefaultMultiChannelConnection(messageHub, connection, null, address);
    }
}

