/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageHub;
import org.gradle.messaging.remote.internal.MultiChannelConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMultiChannelConnection
implements MultiChannelConnection<Object> {
    private final Address sourceAddress;
    private final Address destinationAddress;
    private final MessageHub hub;

    DefaultMultiChannelConnection(MessageHub messageHub, Connection<Message> connection, Address address, Address address2) {
        this.hub = messageHub;
        this.sourceAddress = address;
        this.destinationAddress = address2;
        messageHub.addConnection(connection);
    }

    @Override
    public Address getLocalAddress() {
        if (this.sourceAddress == null) {
            throw new UnsupportedOperationException();
        }
        return this.sourceAddress;
    }

    @Override
    public Address getRemoteAddress() {
        if (this.destinationAddress == null) {
            throw new UnsupportedOperationException();
        }
        return this.destinationAddress;
    }

    @Override
    public void addIncomingChannel(String string, Dispatch<Object> dispatch) {
        this.hub.addIncoming(string, dispatch);
    }

    @Override
    public Dispatch<Object> addOutgoingChannel(String string) {
        return this.hub.addUnicastOutgoing(string);
    }

    @Override
    public void requestStop() {
        this.hub.requestStop();
    }

    @Override
    public void stop() {
        this.requestStop();
        this.hub.stop();
    }
}

