/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.DefaultObjectConnection;
import org.gradle.messaging.remote.internal.IncomingMethodInvocationHandler;
import org.gradle.messaging.remote.internal.MultiChannelConnection;
import org.gradle.messaging.remote.internal.MultiChannelConnector;
import org.gradle.messaging.remote.internal.OutgoingMethodInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessagingServer
implements MessagingServer,
Stoppable {
    private final MultiChannelConnector connector;
    private final ClassLoader classLoader;
    private final Set<ObjectConnection> connections = new CopyOnWriteArraySet<ObjectConnection>();

    public DefaultMessagingServer(MultiChannelConnector multiChannelConnector, ClassLoader classLoader) {
        this.connector = multiChannelConnector;
        this.classLoader = classLoader;
    }

    @Override
    public Address accept(final Action<ConnectEvent<ObjectConnection>> action) {
        return this.connector.accept(new Action<ConnectEvent<MultiChannelConnection<Object>>>(){

            @Override
            public void execute(ConnectEvent<MultiChannelConnection<Object>> connectEvent) {
                DefaultMessagingServer.this.finishConnect(connectEvent, action);
            }
        });
    }

    private void finishConnect(ConnectEvent<MultiChannelConnection<Object>> connectEvent, Action<ConnectEvent<ObjectConnection>> action) {
        MultiChannelConnection<Object> multiChannelConnection = connectEvent.getConnection();
        IncomingMethodInvocationHandler incomingMethodInvocationHandler = new IncomingMethodInvocationHandler(multiChannelConnection);
        OutgoingMethodInvocationHandler outgoingMethodInvocationHandler = new OutgoingMethodInvocationHandler(multiChannelConnection);
        AtomicReference<ObjectConnection> atomicReference = new AtomicReference<ObjectConnection>();
        ConnectionAsyncStoppable connectionAsyncStoppable = new ConnectionAsyncStoppable(multiChannelConnection, atomicReference);
        DefaultObjectConnection defaultObjectConnection = new DefaultObjectConnection(multiChannelConnection, connectionAsyncStoppable, outgoingMethodInvocationHandler, incomingMethodInvocationHandler);
        atomicReference.set(defaultObjectConnection);
        this.connections.add(defaultObjectConnection);
        action.execute(new ConnectEvent<DefaultObjectConnection>(defaultObjectConnection, connectEvent.getLocalAddress(), connectEvent.getRemoteAddress()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        for (ObjectConnection objectConnection : this.connections) {
            objectConnection.requestStop();
        }
        try {
            new CompositeStoppable(this.connections).stop();
        }
        finally {
            this.connections.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionAsyncStoppable
    implements AsyncStoppable {
        private final MultiChannelConnection<Object> messageConnection;
        private final AtomicReference<ObjectConnection> connectionRef;

        public ConnectionAsyncStoppable(MultiChannelConnection<Object> multiChannelConnection, AtomicReference<ObjectConnection> atomicReference) {
            this.messageConnection = multiChannelConnection;
            this.connectionRef = atomicReference;
        }

        @Override
        public void requestStop() {
            this.messageConnection.requestStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                this.messageConnection.stop();
            }
            finally {
                DefaultMessagingServer.this.connections.remove(this.connectionRef.get());
            }
        }
    }
}

