/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.MessagingClient;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.DefaultObjectConnection;
import org.gradle.messaging.remote.internal.IncomingMethodInvocationHandler;
import org.gradle.messaging.remote.internal.MultiChannelConnection;
import org.gradle.messaging.remote.internal.MultiChannelConnector;
import org.gradle.messaging.remote.internal.OutgoingMethodInvocationHandler;

public class DefaultMessagingClient
implements MessagingClient,
Stoppable {
    private final Set<ObjectConnection> connections = new HashSet<ObjectConnection>();
    private final MultiChannelConnector connector;
    private final ClassLoader classLoader;

    public DefaultMessagingClient(MultiChannelConnector multiChannelConnector, ClassLoader classLoader) {
        this.connector = multiChannelConnector;
        this.classLoader = classLoader;
    }

    public ObjectConnection getConnection(Address address) {
        MultiChannelConnection<Object> multiChannelConnection = this.connector.connect(address);
        IncomingMethodInvocationHandler incomingMethodInvocationHandler = new IncomingMethodInvocationHandler(multiChannelConnection);
        OutgoingMethodInvocationHandler outgoingMethodInvocationHandler = new OutgoingMethodInvocationHandler(multiChannelConnection);
        DefaultObjectConnection defaultObjectConnection = new DefaultObjectConnection(multiChannelConnection, multiChannelConnection, outgoingMethodInvocationHandler, incomingMethodInvocationHandler);
        this.connections.add(defaultObjectConnection);
        return defaultObjectConnection;
    }

    public void stop() {
        new CompositeStoppable(this.connections).stop();
    }
}

