/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.DiscardingFailureHandler;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.ChannelRegistrationProtocol;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.GroupMessageFilter;
import org.gradle.messaging.remote.internal.IncomingBroadcast;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.MessageHub;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.ProtocolStack;
import org.gradle.messaging.remote.internal.TypeCastDispatch;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIncomingBroadcast
implements IncomingBroadcast,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncomingBroadcast.class);
    private final ProtocolStack<DiscoveryMessage> protocolStack;
    private final MessageOriginator messageOriginator;
    private final String group;
    private final Lock lock = new ReentrantLock();
    private final Set<String> channels = new HashSet<String>();
    private final StoppableExecutor executor;
    private final Address address;
    private final MessageHub hub;

    public DefaultIncomingBroadcast(MessageOriginator messageOriginator, String string, AsyncConnection<DiscoveryMessage> asyncConnection, IncomingConnector<Message> incomingConnector, ExecutorFactory executorFactory, IdGenerator<?> idGenerator, ClassLoader classLoader) {
        this.messageOriginator = messageOriginator;
        this.group = string;
        this.executor = executorFactory.create("discovery broadcast");
        DiscardingFailureHandler discardingFailureHandler = new DiscardingFailureHandler(LOGGER);
        this.protocolStack = new ProtocolStack(this.executor, discardingFailureHandler, discardingFailureHandler, new ChannelRegistrationProtocol(messageOriginator));
        asyncConnection.dispatchTo(new GroupMessageFilter(string, this.protocolStack.getBottom()));
        this.protocolStack.getBottom().dispatchTo(asyncConnection);
        this.address = incomingConnector.accept(new IncomingConnectionAction(), true);
        this.hub = new MessageHub("incoming broadcast", messageOriginator.getName(), executorFactory, idGenerator, classLoader);
        LOGGER.info("Created IncomingBroadcast with {}", (Object)messageOriginator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addIncoming(Class<T> clazz, T t) {
        String string = clazz.getName();
        this.lock.lock();
        try {
            if (this.channels.add(string)) {
                this.protocolStack.getTop().dispatch(new ChannelAvailable(this.messageOriginator, this.group, string, this.address));
            }
        }
        finally {
            this.lock.unlock();
        }
        this.hub.addIncoming(string, new TypeCastDispatch(MethodInvocation.class, new ReflectionDispatch(t)));
    }

    public void stop() {
        new CompositeStoppable(new Object[0]).add(new Object[]{this.protocolStack, this.hub, this.executor}).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IncomingConnectionAction
    implements Action<ConnectEvent<Connection<Message>>> {
        private IncomingConnectionAction() {
        }

        @Override
        public void execute(ConnectEvent<Connection<Message>> connectEvent) {
            DefaultIncomingBroadcast.this.hub.addConnection(connectEvent.getConnection());
        }
    }
}

