/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.ChannelUnavailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelRegistrationProtocol
implements Protocol<DiscoveryMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelRegistrationProtocol.class);
    private final Map<String, ChannelAvailable> channels = new HashMap<String, ChannelAvailable>();
    private final MessageOriginator messageOriginator;
    private ProtocolContext<DiscoveryMessage> context;

    public ChannelRegistrationProtocol(MessageOriginator messageOriginator) {
        this.messageOriginator = messageOriginator;
    }

    @Override
    public void start(ProtocolContext<DiscoveryMessage> protocolContext) {
        this.context = protocolContext;
    }

    @Override
    public void handleIncoming(DiscoveryMessage discoveryMessage) {
        if (discoveryMessage instanceof LookupRequest) {
            this.handleLookup((LookupRequest)discoveryMessage);
        } else if (!(discoveryMessage instanceof ChannelAvailable) && !(discoveryMessage instanceof ChannelUnavailable)) {
            LOGGER.info("Received unexpected discovery message - discarding: {}", (Object)discoveryMessage);
        } else {
            LOGGER.info("Ignoring discovery message: {}", (Object)discoveryMessage);
        }
    }

    @Override
    public void handleOutgoing(DiscoveryMessage discoveryMessage) {
        if (discoveryMessage instanceof ChannelAvailable) {
            ChannelAvailable channelAvailable = (ChannelAvailable)discoveryMessage;
            this.channels.put(channelAvailable.getChannel(), channelAvailable);
            LOGGER.info("Channel registered. Broadcasting {}.", (Object)discoveryMessage);
            this.context.dispatchOutgoing(discoveryMessage);
        } else if (discoveryMessage instanceof ChannelUnavailable) {
            ChannelUnavailable channelUnavailable = (ChannelUnavailable)discoveryMessage;
            this.channels.remove(channelUnavailable.getChannel());
            LOGGER.info("Channel unregistered. Broadcasting {}.", (Object)discoveryMessage);
            this.context.dispatchOutgoing(discoveryMessage);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void handleLookup(LookupRequest lookupRequest) {
        ChannelAvailable channelAvailable = this.channels.get(lookupRequest.getChannel());
        if (channelAvailable != null) {
            LOGGER.info("Replying to lookup request for known channel. Request: {}. Response: {}.", (Object)lookupRequest, (Object)channelAvailable);
            this.context.dispatchOutgoing(channelAvailable);
        } else {
            LOGGER.info("Received lookup request for unknown channel - discarding: {}", (Object)lookupRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRequested() {
        try {
            for (ChannelAvailable channelAvailable : this.channels.values()) {
                this.context.dispatchOutgoing(new ChannelUnavailable(this.messageOriginator, channelAvailable.getGroup(), channelAvailable.getChannel(), channelAvailable.getAddress()));
            }
        }
        finally {
            this.channels.clear();
            this.context.stopped();
        }
    }
}

