/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.ChannelUnavailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelLookupProtocol
implements Protocol<DiscoveryMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelLookupProtocol.class);
    private final Map<String, RequestDetails> channels = new HashMap<String, RequestDetails>();
    private ProtocolContext<DiscoveryMessage> context;

    @Override
    public void start(ProtocolContext<DiscoveryMessage> protocolContext) {
        this.context = protocolContext;
    }

    @Override
    public void handleOutgoing(DiscoveryMessage discoveryMessage) {
        if (!(discoveryMessage instanceof LookupRequest)) {
            throw new UnsupportedOperationException();
        }
        LookupRequest lookupRequest = (LookupRequest)discoveryMessage;
        LOGGER.info("Broadcasting lookup request: {}", (Object)lookupRequest);
        RequestDetails requestDetails = new RequestDetails(lookupRequest);
        this.channels.put(lookupRequest.getChannel(), requestDetails);
        requestDetails.run();
    }

    @Override
    public void handleIncoming(DiscoveryMessage discoveryMessage) {
        if (discoveryMessage instanceof ChannelAvailable) {
            ChannelAvailable channelAvailable = (ChannelAvailable)discoveryMessage;
            LOGGER.info("Channel discovered: {}", (Object)channelAvailable);
            RequestDetails requestDetails = this.channels.get(channelAvailable.getChannel());
            if (requestDetails != null) {
                LOGGER.info("Processing request on channel: {}", (Object)requestDetails.lookupRequest);
                requestDetails.handleResponse(channelAvailable);
            } else {
                LOGGER.info("No request for channel, ignoring.");
            }
        } else if (!(discoveryMessage instanceof LookupRequest) && !(discoveryMessage instanceof ChannelUnavailable)) {
            LOGGER.info("Received unknown discovery message - discarding: {}", (Object)discoveryMessage);
        } else {
            LOGGER.info("Ignored incoming discovery message {}", (Object)discoveryMessage);
        }
    }

    @Override
    public void stopRequested() {
        this.context.stopped();
    }

    private class RequestDetails
    implements Runnable {
        private final LookupRequest lookupRequest;
        ProtocolContext.Callback timeout;
        int attempts;

        public RequestDetails(LookupRequest lookupRequest) {
            this.lookupRequest = lookupRequest;
        }

        public void handleResponse(ChannelAvailable channelAvailable) {
            this.timeout.cancel();
            ChannelLookupProtocol.this.context.dispatchIncoming(channelAvailable);
        }

        public void run() {
            ++this.attempts;
            this.timeout = ChannelLookupProtocol.this.context.callbackLater(this.getTimeoutSeconds(), TimeUnit.SECONDS, this);
            ChannelLookupProtocol.this.context.dispatchOutgoing(this.lookupRequest);
        }

        private int getTimeoutSeconds() {
            if (this.attempts > 10) {
                return 30;
            }
            if (this.attempts > 5) {
                return 10;
            }
            return 1;
        }
    }
}

