/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.AsyncReceive;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.gradle.messaging.dispatch.FailureHandlingDispatch;
import org.gradle.messaging.dispatch.Receive;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncConnectionAdapter<T>
implements AsyncConnection<T>,
Stoppable {
    private final Connection<T> connection;
    private final AsyncReceive<T> incoming;
    private final ProtocolStack<T> stack;
    private final AsyncDispatch<T> outgoing;
    private final Set<Stoppable> executors = new HashSet<Stoppable>();

    public AsyncConnectionAdapter(Connection<T> connection, DispatchFailureHandler<? super T> dispatchFailureHandler, ExecutorFactory executorFactory, Protocol<T> ... protocolArray) {
        this.connection = connection;
        StoppableExecutor stoppableExecutor = executorFactory.create(String.format("%s send", connection));
        this.executors.add(stoppableExecutor);
        this.outgoing = new AsyncDispatch(stoppableExecutor);
        this.outgoing.dispatchTo(new FailureHandlingDispatch<T>(connection, dispatchFailureHandler));
        StoppableExecutor stoppableExecutor2 = executorFactory.create(String.format("%s dispatch", connection));
        this.executors.add(stoppableExecutor2);
        this.stack = new ProtocolStack<T>(stoppableExecutor2, dispatchFailureHandler, dispatchFailureHandler, protocolArray);
        this.stack.getBottom().dispatchTo(this.outgoing);
        StoppableExecutor stoppableExecutor3 = executorFactory.create(String.format("%s receive", connection));
        this.executors.add(stoppableExecutor3);
        this.incoming = new AsyncReceive(stoppableExecutor3);
        this.incoming.dispatchTo(this.stack.getBottom());
        this.incoming.receiveFrom(new ConnectionReceive<T>(connection));
    }

    @Override
    public void dispatch(T t) {
        this.stack.getTop().dispatch(t);
    }

    @Override
    public void dispatchTo(Dispatch<? super T> dispatch) {
        this.stack.getTop().dispatchTo(dispatch);
    }

    public void stop() {
        new CompositeStoppable(new Object[]{this.stack, this.outgoing, this.connection, this.incoming}).add(this.executors).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionReceive<T>
    implements Receive<T> {
        private final Connection<T> connection;

        public ConnectionReceive(Connection<T> connection) {
            this.connection = connection;
        }

        @Override
        public T receive() {
            Object t = this.connection.receive();
            if (t == null) {
                AsyncConnectionAdapter.this.stack.requestStop();
            }
            return t;
        }
    }
}

