/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDispatchAdapter<T> {
    private final Class<T> type;
    private final T source;

    public ProxyDispatchAdapter(Dispatch<? super MethodInvocation> dispatch, Class<T> clazz, Class<?> ... classArray) {
        this.type = clazz;
        ArrayList arrayList = new ArrayList();
        ClassLoader classLoader = clazz.getClassLoader();
        arrayList.add(clazz);
        for (Class<?> clazz2 : classArray) {
            ClassLoader classLoader2 = clazz2.getClassLoader();
            if (classLoader2 != classLoader && classLoader2 != null) {
                try {
                    if (classLoader2.loadClass(clazz.getName()) != null) {
                        classLoader = classLoader2;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            arrayList.add(clazz2);
        }
        this.source = clazz.cast(Proxy.newProxyInstance(classLoader, arrayList.toArray(new Class[arrayList.size()]), (InvocationHandler)new DispatchingInvocationHandler(clazz, dispatch)));
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getSource() {
        return this.source;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DispatchingInvocationHandler
    implements InvocationHandler {
        private final Class<?> type;
        private final Dispatch<? super MethodInvocation> dispatch;

        private DispatchingInvocationHandler(Class<?> clazz, Dispatch<? super MethodInvocation> dispatch) {
            this.type = clazz;
            this.dispatch = dispatch;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("equals")) {
                Object object2 = objectArray[0];
                if (object2 == null || !Proxy.isProxyClass(object2.getClass())) {
                    return false;
                }
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(object2);
                if (!DispatchingInvocationHandler.class.isInstance(invocationHandler)) {
                    return false;
                }
                DispatchingInvocationHandler dispatchingInvocationHandler = (DispatchingInvocationHandler)invocationHandler;
                return dispatchingInvocationHandler.type.equals(this.type) && dispatchingInvocationHandler.dispatch == this.dispatch;
            }
            if (method.getName().equals("hashCode")) {
                return this.dispatch.hashCode();
            }
            if (method.getName().equals("toString")) {
                return String.format("%s broadcast", this.type.getSimpleName());
            }
            this.dispatch.dispatch(new MethodInvocation(method, objectArray));
            return null;
        }
    }
}

