/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import java.util.Date;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.dispatch.Receive;
import org.gradle.util.TimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayedReceive<T>
implements Stoppable,
Receive<T> {
    private final TimeProvider timeProvider;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final PriorityQueue<DelayedMessage> queue = new PriorityQueue();
    private boolean stopping;

    public DelayedReceive(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T receive() {
        DelayedMessage delayedMessage;
        this.lock.lock();
        try {
            while (true) {
                if ((delayedMessage = this.queue.peek()) == null && this.stopping) {
                    T t = null;
                    return t;
                }
                if (delayedMessage == null) {
                    this.condition.await();
                    continue;
                }
                long l = this.timeProvider.getCurrentTime();
                if (delayedMessage.dispatchTime <= l) break;
                this.condition.awaitUntil(new Date(delayedMessage.dispatchTime));
                continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
        }
        this.queue.poll();
        if (this.queue.isEmpty()) {
            this.condition.signalAll();
        }
        Object object = delayedMessage.message;
        return (T)object;
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchLater(T t, int n, TimeUnit timeUnit) {
        long l = this.timeProvider.getCurrentTime() + timeUnit.toMillis(n);
        this.lock.lock();
        try {
            if (this.stopping) {
                throw new IllegalStateException("This dispatch has been stopped.");
            }
            this.queue.add(new DelayedMessage(l, t));
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        this.lock.lock();
        try {
            Iterator<DelayedMessage> iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                DelayedMessage delayedMessage = iterator.next();
                if (!delayedMessage.message.equals(t)) continue;
                iterator.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        this.lock.lock();
        try {
            this.stopping = true;
            this.condition.signalAll();
            while (!this.queue.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelayedMessage
    implements Comparable<DelayedMessage> {
        private final long dispatchTime;
        private final T message;

        private DelayedMessage(long l, T t) {
            this.dispatchTime = l;
            this.message = t;
        }

        @Override
        public int compareTo(DelayedMessage delayedMessage) {
            if (this.dispatchTime > delayedMessage.dispatchTime) {
                return 1;
            }
            if (this.dispatchTime < delayedMessage.dispatchTime) {
                return -1;
            }
            return 0;
        }
    }
}

