/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import org.gradle.messaging.dispatch.Dispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextClassLoaderDispatch<T>
implements Dispatch<T> {
    private final Dispatch<? super T> dispatch;
    private final ClassLoader contextClassLoader;

    public ContextClassLoaderDispatch(Dispatch<? super T> dispatch, ClassLoader classLoader) {
        this.dispatch = dispatch;
        this.contextClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(T t) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            this.dispatch.dispatch(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

