/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import groovy.lang.Closure;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.listener.ListenerNotificationException;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchException;
import org.gradle.messaging.dispatch.ExceptionTrackingFailureHandler;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.dispatch.StoppableDispatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastDispatch<T>
implements StoppableDispatch<MethodInvocation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BroadcastDispatch.class);
    private final Class<T> type;
    private final Map<Object, Dispatch<MethodInvocation>> handlers = new LinkedHashMap<Object, Dispatch<MethodInvocation>>();

    public BroadcastDispatch(Class<T> clazz) {
        this.type = clazz;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void add(Dispatch<MethodInvocation> dispatch) {
        this.handlers.put(dispatch, dispatch);
    }

    public void add(T t) {
        this.handlers.put(t, new ReflectionDispatch(t));
    }

    public void add(String string, Closure closure) {
        this.assertIsMethod(string);
        this.handlers.put(closure, new ClosureInvocationHandler(string, closure));
    }

    public void add(String string, Action<?> action) {
        this.assertIsMethod(string);
        this.handlers.put(action, new ActionInvocationHandler(string, action));
    }

    private void assertIsMethod(String string) {
        for (Method method : this.type.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method %s() not found for listener type %s.", string, this.type.getSimpleName()));
    }

    public void remove(Object object) {
        this.handlers.remove(object);
    }

    private String getErrorMessage() {
        String string = this.type.getSimpleName().replaceAll("(\\p{Upper})", " $1").trim().toLowerCase();
        return String.format("Failed to notify %s.", string);
    }

    @Override
    public void dispatch(MethodInvocation methodInvocation) {
        try {
            ExceptionTrackingFailureHandler exceptionTrackingFailureHandler = new ExceptionTrackingFailureHandler(LOGGER);
            for (Dispatch<MethodInvocation> dispatch : new ArrayList<Dispatch<MethodInvocation>>(this.handlers.values())) {
                try {
                    dispatch.dispatch(methodInvocation);
                }
                catch (UncheckedException uncheckedException) {
                    exceptionTrackingFailureHandler.dispatchFailed(methodInvocation, uncheckedException.getCause());
                }
                catch (Throwable throwable) {
                    exceptionTrackingFailureHandler.dispatchFailed(methodInvocation, throwable);
                }
            }
            exceptionTrackingFailureHandler.stop();
        }
        catch (DispatchException dispatchException) {
            throw new ListenerNotificationException(this.getErrorMessage(), dispatchException.getCause());
        }
    }

    @Override
    public void stop() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Action action;

        public ActionInvocationHandler(String string, Action action) {
            this.methodName = string;
            this.action = action;
        }

        @Override
        public void dispatch(MethodInvocation methodInvocation) {
            if (methodInvocation.getMethod().getName().equals(this.methodName)) {
                this.action.execute(methodInvocation.getArguments()[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClosureInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Closure closure;

        public ClosureInvocationHandler(String string, Closure closure) {
            this.methodName = string;
            this.closure = closure;
        }

        @Override
        public void dispatch(MethodInvocation methodInvocation) {
            if (methodInvocation.getMethod().getName().equals(this.methodName)) {
                Object[] objectArray = methodInvocation.getArguments();
                if (this.closure.getMaximumNumberOfParameters() < objectArray.length) {
                    objectArray = Arrays.asList(objectArray).subList(0, this.closure.getMaximumNumberOfParameters()).toArray();
                }
                this.closure.call(objectArray);
            }
        }
    }
}

