/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.logging.Logging;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.DispatchException;
import org.gradle.messaging.dispatch.ExceptionTrackingFailureHandler;

public class DefaultExecutorFactory
implements ExecutorFactory,
Stoppable {
    private final Set<StoppableExecutorImpl> executors = new CopyOnWriteArraySet<StoppableExecutorImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            new CompositeStoppable(this.executors).stop();
        }
        finally {
            this.executors.clear();
        }
    }

    public StoppableExecutor create(String string) {
        StoppableExecutorImpl stoppableExecutorImpl = new StoppableExecutorImpl(this.createExecutor(string));
        this.executors.add(stoppableExecutorImpl);
        return stoppableExecutorImpl;
    }

    protected ExecutorService createExecutor(String string) {
        return Executors.newCachedThreadPool(new ThreadFactoryImpl(string));
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private final AtomicLong counter = new AtomicLong();
        private final String displayName;

        public ThreadFactoryImpl(String string) {
            this.displayName = string;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            long l = this.counter.incrementAndGet();
            if (l == 1L) {
                thread.setName(this.displayName);
            } else {
                thread.setName(String.format("%s Thread %s", this.displayName, l));
            }
            return thread;
        }
    }

    private class StoppableExecutorImpl
    implements StoppableExecutor {
        private final ExecutorService executor;
        private final ExceptionTrackingFailureHandler failureHandler;
        private final ThreadLocal<Runnable> executing = new ThreadLocal();

        public StoppableExecutorImpl(ExecutorService executorService) {
            this.executor = executorService;
            this.failureHandler = new ExceptionTrackingFailureHandler(Logging.getLogger(StoppableExecutorImpl.class));
        }

        public void execute(final Runnable runnable) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    StoppableExecutorImpl.this.executing.set(runnable);
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        StoppableExecutorImpl.this.failureHandler.dispatchFailed(runnable, throwable);
                    }
                    finally {
                        StoppableExecutorImpl.this.executing.set(null);
                    }
                }
            });
        }

        public void requestStop() {
            this.executor.shutdown();
        }

        public void stop() {
            this.stop(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(int n, TimeUnit timeUnit) throws IllegalStateException {
            this.requestStop();
            if (this.executing.get() != null) {
                throw new IllegalStateException("Cannot stop this executor from an executor thread.");
            }
            try {
                try {
                    if (!this.executor.awaitTermination(n, timeUnit)) {
                        this.executor.shutdownNow();
                        throw new IllegalStateException("Timeout waiting for concurrent jobs to complete.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new UncheckedException((Throwable)interruptedException);
                }
                try {
                    this.failureHandler.stop();
                }
                catch (DispatchException dispatchException) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)dispatchException.getCause());
                }
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }
}

