/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.actor.internal;

import java.util.IdentityHashMap;
import java.util.Map;
import org.gradle.api.logging.Logging;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.messaging.actor.Actor;
import org.gradle.messaging.actor.ActorFactory;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchException;
import org.gradle.messaging.dispatch.ExceptionTrackingFailureHandler;
import org.gradle.messaging.dispatch.FailureHandlingDispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ProxyDispatchAdapter;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.dispatch.StoppableDispatch;

public class DefaultActorFactory
implements ActorFactory,
Stoppable {
    private final Map<Object, NonBlockingActor> nonBlockingActors = new IdentityHashMap<Object, NonBlockingActor>();
    private final Map<Object, BlockingActor> blockingActors = new IdentityHashMap<Object, BlockingActor>();
    private final Object lock = new Object();
    private final ExecutorFactory executorFactory;

    public DefaultActorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            try {
                new CompositeStoppable(new Object[0]).add(this.nonBlockingActors.values()).add(this.blockingActors.values()).stop();
            }
            finally {
                this.nonBlockingActors.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Actor createActor(Object object) {
        if (object instanceof NonBlockingActor) {
            return (NonBlockingActor)object;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.blockingActors.containsKey(object)) {
                throw new UnsupportedOperationException("Cannot create a non-blocking and blocking actor for the same object. This is not implemented yet.");
            }
            NonBlockingActor nonBlockingActor = this.nonBlockingActors.get(object);
            if (nonBlockingActor == null) {
                nonBlockingActor = new NonBlockingActor(object);
                this.nonBlockingActors.put(object, nonBlockingActor);
            }
            return nonBlockingActor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Actor createBlockingActor(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.nonBlockingActors.containsKey(object)) {
                throw new UnsupportedOperationException("Cannot create a non-blocking and blocking actor for the same object. This is not implemented yet.");
            }
            BlockingActor blockingActor = this.blockingActors.get(object);
            if (blockingActor == null) {
                blockingActor = new BlockingActor(object);
                this.blockingActors.put(object, blockingActor);
            }
            return blockingActor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(NonBlockingActor nonBlockingActor) {
        Object object = this.lock;
        synchronized (object) {
            this.nonBlockingActors.values().remove(nonBlockingActor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(BlockingActor blockingActor) {
        Object object = this.lock;
        synchronized (object) {
            this.blockingActors.values().remove(blockingActor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NonBlockingActor
    implements Actor {
        private final StoppableDispatch<MethodInvocation> dispatch;
        private final StoppableExecutor executor;
        private final ExceptionTrackingFailureHandler failureHandler;

        public NonBlockingActor(Object object) {
            this.executor = DefaultActorFactory.this.executorFactory.create(String.format("Dispatch %s", object));
            this.failureHandler = new ExceptionTrackingFailureHandler(Logging.getLogger(NonBlockingActor.class));
            this.dispatch = new AsyncDispatch<Object>(this.executor, new FailureHandlingDispatch<Object>(new ReflectionDispatch(object), this.failureHandler));
        }

        @Override
        public <T> T getProxy(Class<T> clazz) {
            return new ProxyDispatchAdapter<T>(this, clazz, ThreadSafe.class).getSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                new CompositeStoppable(new Object[]{this.dispatch, this.executor, this.failureHandler}).stop();
            }
            finally {
                DefaultActorFactory.this.stopped(this);
            }
        }

        @Override
        public void dispatch(MethodInvocation methodInvocation) {
            this.dispatch.dispatch(methodInvocation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockingActor
    implements Actor {
        private final Dispatch<MethodInvocation> dispatch;
        private final Object lock = new Object();
        private boolean stopped;

        public BlockingActor(Object object) {
            this.dispatch = new ReflectionDispatch(object);
        }

        @Override
        public <T> T getProxy(Class<T> clazz) {
            return new ProxyDispatchAdapter<T>(this, clazz, ThreadSafe.class).getSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() throws DispatchException {
            Object object = this.lock;
            synchronized (object) {
                this.stopped = true;
            }
            DefaultActorFactory.this.stopped(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(MethodInvocation methodInvocation) {
            Object object = this.lock;
            synchronized (object) {
                if (this.stopped) {
                    throw new IllegalStateException("This actor has been stopped.");
                }
                this.dispatch.dispatch(methodInvocation);
            }
        }
    }
}

