/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal.slf4j;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.io.PrintStream;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.logging.internal.LogEvent;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.MarkerFilter;
import org.gradle.logging.internal.OutputEventListener;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slf4jLoggingConfigurer
implements LoggingConfigurer {
    private final Appender appender;
    private LogLevel currentLevel;
    private final PrintStream defaultStdOut = System.out;

    public Slf4jLoggingConfigurer(OutputEventListener outputEventListener) {
        this.appender = new Appender(outputEventListener);
    }

    @Override
    public void configure(LogLevel logLevel) {
        if (this.currentLevel == logLevel) {
            return;
        }
        try {
            this.doConfigure(logLevel);
        }
        catch (Throwable throwable) {
            this.doFailsafeConfiguration();
            throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
        }
    }

    private void doFailsafeConfiguration() {
        final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>(){
            {
                this.setContext((Context)loggerContext);
                this.setTarget("System.err");
                this.setLayout((Layout)new PatternLayout(){
                    {
                        this.setPattern("%msg%n%ex");
                        this.setContext((Context)loggerContext);
                        this.start();
                    }
                });
                this.start();
            }
        };
        Logger logger = loggerContext.getLogger("ROOT");
        logger.setLevel(Level.INFO);
        logger.addAppender((ch.qos.logback.core.Appender)consoleAppender);
    }

    private void doConfigure(LogLevel logLevel) {
        Logger logger;
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        if (this.currentLevel == null) {
            loggerContext.reset();
            this.appender.setContext((Context)loggerContext);
            logger = loggerContext.getLogger("ROOT");
            logger.addAppender((ch.qos.logback.core.Appender)this.appender);
        } else {
            logger = loggerContext.getLogger("ROOT");
        }
        this.currentLevel = logLevel;
        this.appender.stop();
        this.appender.clearAllFilters();
        switch (logLevel) {
            case DEBUG: {
                logger.setLevel(Level.DEBUG);
                break;
            }
            case INFO: {
                logger.setLevel(Level.INFO);
                break;
            }
            case LIFECYCLE: {
                this.appender.addFilter(new MarkerFilter(Logging.QUIET, Logging.LIFECYCLE));
                this.appender.addFilter(this.createLevelFilter(loggerContext, Level.INFO, FilterReply.DENY, FilterReply.NEUTRAL));
                logger.setLevel(Level.INFO);
                break;
            }
            case QUIET: {
                this.appender.addFilter(new MarkerFilter(Logging.QUIET));
                this.appender.addFilter(this.createLevelFilter(loggerContext, Level.INFO, FilterReply.DENY, FilterReply.NEUTRAL));
                logger.setLevel(Level.INFO);
                break;
            }
            case WARN: {
                logger.setLevel(Level.WARN);
                break;
            }
            case ERROR: {
                logger.setLevel(Level.ERROR);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        loggerContext.getLogger("org.apache.http.wire").setLevel(Level.OFF);
        this.appender.start();
    }

    private Filter<ILoggingEvent> createLevelFilter(LoggerContext loggerContext, Level level, FilterReply filterReply, FilterReply filterReply2) {
        LevelFilter levelFilter = new LevelFilter();
        levelFilter.setContext((Context)loggerContext);
        levelFilter.setOnMatch(filterReply);
        levelFilter.setOnMismatch(filterReply2);
        levelFilter.setLevel(level);
        levelFilter.start();
        return levelFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Appender
    extends AppenderBase<ILoggingEvent> {
        private final OutputEventListener listener;

        private Appender(OutputEventListener outputEventListener) {
            this.listener = outputEventListener;
        }

        protected void append(ILoggingEvent iLoggingEvent) {
            try {
                ThrowableProxy throwableProxy = (ThrowableProxy)iLoggingEvent.getThrowableProxy();
                Throwable throwable = throwableProxy == null ? null : throwableProxy.getThrowable();
                String string = iLoggingEvent.getFormattedMessage();
                this.listener.onOutput(new LogEvent(iLoggingEvent.getTimeStamp(), iLoggingEvent.getLoggerName(), this.toLogLevel(iLoggingEvent), string, throwable));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(Slf4jLoggingConfigurer.this.defaultStdOut);
            }
        }

        private LogLevel toLogLevel(ILoggingEvent iLoggingEvent) {
            switch (iLoggingEvent.getLevel().toInt()) {
                case 10000: {
                    return LogLevel.DEBUG;
                }
                case 20000: {
                    if (iLoggingEvent.getMarker() == Logging.LIFECYCLE) {
                        return LogLevel.LIFECYCLE;
                    }
                    if (iLoggingEvent.getMarker() == Logging.QUIET) {
                        return LogLevel.QUIET;
                    }
                    return LogLevel.INFO;
                }
                case 30000: {
                    return LogLevel.WARN;
                }
                case 40000: {
                    return LogLevel.ERROR;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot map SLF4j Level %s to a LogLevel", iLoggingEvent.getLevel()));
        }
    }
}

