/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.logging.LogLevel;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.StyledTextOutputEvent;

public class TextStreamOutputEventListener
implements OutputEventListener {
    private final OutputEventListener listener;
    private AtomicReference<LogLevel> logLevel = new AtomicReference<LogLevel>(LogLevel.LIFECYCLE);

    public TextStreamOutputEventListener(OutputEventListener outputEventListener) {
        this.listener = outputEventListener;
    }

    public void onOutput(OutputEvent outputEvent) {
        if (outputEvent instanceof StyledTextOutputEvent) {
            this.onTextEvent((StyledTextOutputEvent)outputEvent);
        } else if (outputEvent instanceof LogLevelChangeEvent) {
            this.onLogLevelChange((LogLevelChangeEvent)outputEvent);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void onLogLevelChange(LogLevelChangeEvent logLevelChangeEvent) {
        this.logLevel.set(logLevelChangeEvent.getNewLogLevel());
    }

    private void onTextEvent(StyledTextOutputEvent styledTextOutputEvent) {
        if (styledTextOutputEvent.getLogLevel() != null) {
            this.listener.onOutput(styledTextOutputEvent);
        } else {
            this.listener.onOutput(styledTextOutputEvent.withLogLevel(this.logLevel.get()));
        }
    }
}

