/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.RenderableOutputEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledTextOutputEvent
extends RenderableOutputEvent {
    private final List<Span> spans;

    public StyledTextOutputEvent(long l, String string, String string2) {
        this(l, string, StyledTextOutput.Style.Normal, string2);
    }

    public StyledTextOutputEvent(long l, String string, LogLevel logLevel, String string2) {
        this(l, string, logLevel, StyledTextOutput.Style.Normal, string2);
    }

    public StyledTextOutputEvent(long l, String string, StyledTextOutput.Style style, String string2) {
        this(l, string, null, style, string2);
    }

    public StyledTextOutputEvent(long l, String string, LogLevel logLevel, StyledTextOutput.Style style, String string2) {
        this(l, string, logLevel, Collections.singletonList(new Span(style, string2)));
    }

    public StyledTextOutputEvent(long l, String string, List<Span> list) {
        this(l, string, null, list);
    }

    public StyledTextOutputEvent(long l, String string, LogLevel logLevel, Span ... spanArray) {
        this(l, string, logLevel, Arrays.asList(spanArray));
    }

    public StyledTextOutputEvent(long l, String string, LogLevel logLevel, List<Span> list) {
        super(l, string, logLevel);
        this.spans = new ArrayList<Span>(list);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getLogLevel()).append("] [");
        stringBuilder.append(this.getCategory()).append("] ");
        for (Span span : this.spans) {
            stringBuilder.append('<');
            stringBuilder.append((Object)span.style);
            stringBuilder.append(">");
            stringBuilder.append(span.text);
            stringBuilder.append("</");
            stringBuilder.append((Object)span.style);
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    public StyledTextOutputEvent withLogLevel(LogLevel logLevel) {
        return new StyledTextOutputEvent(this.getTimestamp(), this.getCategory(), logLevel, this.spans);
    }

    @Override
    public void render(StyledTextOutput styledTextOutput) {
        for (Span span : this.spans) {
            styledTextOutput.style(span.style);
            styledTextOutput.text(span.text);
        }
    }

    public static class Span
    implements Serializable {
        private final String text;
        private final StyledTextOutput.Style style;

        public Span(StyledTextOutput.Style style, String string) {
            this.style = style;
            this.text = string;
        }

        public Span(String string) {
            this.style = StyledTextOutput.Style.Normal;
            this.text = string;
        }
    }
}

