/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.SystemProperties;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.AbstractLineChoppingStyledTextOutput;
import org.gradle.logging.internal.CategorisedOutputEvent;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.RenderableOutputEvent;

public class StyledTextOutputBackedRenderer
implements OutputEventListener {
    private static final String EOL = SystemProperties.getLineSeparator();
    private final OutputEventTextOutputImpl textOutput;
    private boolean debugOutput;
    private RenderableOutputEvent lastEvent;

    public StyledTextOutputBackedRenderer(StyledTextOutput styledTextOutput) {
        this.textOutput = new OutputEventTextOutputImpl(styledTextOutput);
    }

    public void onOutput(OutputEvent outputEvent) {
        OutputEvent outputEvent2;
        if (outputEvent instanceof LogLevelChangeEvent) {
            outputEvent2 = (LogLevelChangeEvent)outputEvent;
            boolean bl = this.debugOutput = ((LogLevelChangeEvent)outputEvent2).getNewLogLevel() == LogLevel.DEBUG;
        }
        if (outputEvent instanceof RenderableOutputEvent) {
            outputEvent2 = (RenderableOutputEvent)outputEvent;
            this.textOutput.style(((CategorisedOutputEvent)outputEvent2).getLogLevel() == LogLevel.ERROR ? StyledTextOutput.Style.Error : StyledTextOutput.Style.Normal);
            if (this.debugOutput && (this.textOutput.atEndOfLine || this.lastEvent == null || !this.lastEvent.getCategory().equals(((CategorisedOutputEvent)outputEvent2).getCategory()))) {
                if (!this.textOutput.atEndOfLine) {
                    this.textOutput.println();
                }
                this.textOutput.text(new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(((CategorisedOutputEvent)outputEvent2).getTimestamp())));
                this.textOutput.text(" [");
                this.textOutput.text(((CategorisedOutputEvent)outputEvent2).getLogLevel());
                this.textOutput.text("] [");
                this.textOutput.text(((CategorisedOutputEvent)outputEvent2).getCategory());
                this.textOutput.text("] ");
            }
            ((RenderableOutputEvent)outputEvent2).render(this.textOutput);
            this.lastEvent = outputEvent2;
            this.textOutput.style(StyledTextOutput.Style.Normal);
        }
    }

    private class OutputEventTextOutputImpl
    extends AbstractLineChoppingStyledTextOutput {
        private final StyledTextOutput textOutput;
        private boolean atEndOfLine = true;

        public OutputEventTextOutputImpl(StyledTextOutput styledTextOutput) {
            this.textOutput = styledTextOutput;
        }

        protected void doStyleChange(StyledTextOutput.Style style) {
            this.textOutput.style(style);
        }

        protected void doLineText(CharSequence charSequence, boolean bl) {
            this.textOutput.text(charSequence);
            this.atEndOfLine = bl;
        }
    }
}

