/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.logging.internal.AbstractStyledTextOutput;
import org.gradle.logging.internal.StreamBackedStandardOutputListener;

public class StreamingStyledTextOutput
extends AbstractStyledTextOutput
implements Closeable {
    private final StandardOutputListener listener;
    private final Closeable closeable;

    public StreamingStyledTextOutput(StandardOutputListener standardOutputListener) {
        this(standardOutputListener, standardOutputListener);
    }

    public StreamingStyledTextOutput(Appendable appendable) {
        this(appendable, new StreamBackedStandardOutputListener(appendable));
    }

    private StreamingStyledTextOutput(Object object, StandardOutputListener standardOutputListener) {
        this.listener = standardOutputListener;
        this.closeable = object instanceof Closeable ? (Closeable)object : null;
    }

    protected void doAppend(String string) {
        this.listener.onOutput(string);
    }

    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

