/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.StandardOutputListener;

public class StreamBackedStandardOutputListener
implements StandardOutputListener {
    private final Appendable appendable;
    private final Flushable flushable;

    public StreamBackedStandardOutputListener(Appendable appendable) {
        this.appendable = appendable;
        this.flushable = appendable instanceof Flushable ? (Flushable)((Object)appendable) : new Flushable(){

            public void flush() throws IOException {
            }
        };
    }

    public StreamBackedStandardOutputListener(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public void onOutput(CharSequence charSequence) {
        try {
            this.appendable.append(charSequence);
            this.flushable.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

