/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.Iterator;
import java.util.LinkedList;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.SystemProperties;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.logging.internal.RenderableOutputEvent;
import org.gradle.logging.internal.StyledTextOutputEvent;
import org.gradle.util.GUtil;

public class ProgressLogEventGenerator
implements OutputEventListener {
    private static final String EOL = SystemProperties.getLineSeparator();
    private final OutputEventListener listener;
    private final boolean deferHeader;
    private final LinkedList<Operation> operations = new LinkedList();

    public ProgressLogEventGenerator(OutputEventListener outputEventListener, boolean bl) {
        this.listener = outputEventListener;
        this.deferHeader = bl;
    }

    public void onOutput(OutputEvent outputEvent) {
        if (outputEvent instanceof ProgressStartEvent) {
            this.onStart((ProgressStartEvent)outputEvent);
        } else if (outputEvent instanceof ProgressCompleteEvent) {
            this.onComplete((ProgressCompleteEvent)outputEvent);
        } else if (outputEvent instanceof RenderableOutputEvent) {
            this.doOutput((RenderableOutputEvent)outputEvent);
        } else if (!(outputEvent instanceof ProgressEvent)) {
            this.listener.onOutput(outputEvent);
        }
    }

    private void doOutput(RenderableOutputEvent renderableOutputEvent) {
        for (Operation operation : this.operations) {
            operation.completeHeader();
        }
        this.listener.onOutput(renderableOutputEvent);
    }

    private void onComplete(ProgressCompleteEvent progressCompleteEvent) {
        assert (!this.operations.isEmpty());
        Operation operation = this.operations.removeLast();
        operation.status = progressCompleteEvent.getStatus();
        operation.completeTime = progressCompleteEvent.getTimestamp();
        operation.complete();
    }

    private void onStart(ProgressStartEvent progressStartEvent) {
        Operation operation = new Operation(progressStartEvent.getCategory(), progressStartEvent.getLoggingHeader(), progressStartEvent.getTimestamp());
        this.operations.add(operation);
        if (!this.deferHeader || progressStartEvent.getLoggingHeader() == null || !progressStartEvent.getLoggingHeader().equals(progressStartEvent.getShortDescription())) {
            operation.startHeader();
        }
    }

    private class Operation {
        private final String category;
        private final String loggingHeader;
        private final long startTime;
        private final boolean hasLoggingHeader;
        private String status = "";
        private State state = State.None;
        private long completeTime;

        private Operation(String string, String string2, long l) {
            this.category = string;
            this.loggingHeader = string2;
            this.startTime = l;
            this.hasLoggingHeader = GUtil.isTrue(string2);
        }

        private void doOutput(RenderableOutputEvent renderableOutputEvent) {
            Operation operation;
            Iterator iterator = ProgressLogEventGenerator.this.operations.iterator();
            while (iterator.hasNext() && (operation = (Operation)iterator.next()) != this) {
                operation.completeHeader();
            }
            ProgressLogEventGenerator.this.listener.onOutput(renderableOutputEvent);
        }

        public void startHeader() {
            assert (this.state == State.None);
            if (this.hasLoggingHeader) {
                this.state = State.HeaderStarted;
                this.doOutput(new StyledTextOutputEvent(this.startTime, this.category, LogLevel.LIFECYCLE, this.loggingHeader));
            } else {
                this.state = State.HeaderCompleted;
            }
        }

        public void completeHeader() {
            boolean bl = GUtil.isTrue(this.loggingHeader);
            switch (this.state) {
                case None: {
                    if (!bl) break;
                    ProgressLogEventGenerator.this.listener.onOutput(new StyledTextOutputEvent(this.startTime, this.category, LogLevel.LIFECYCLE, this.loggingHeader + EOL));
                    break;
                }
                case HeaderStarted: {
                    ProgressLogEventGenerator.this.listener.onOutput(new StyledTextOutputEvent(this.startTime, this.category, LogLevel.LIFECYCLE, EOL));
                    break;
                }
                case HeaderCompleted: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = State.HeaderCompleted;
        }

        public void complete() {
            boolean bl = GUtil.isTrue(this.status);
            switch (this.state) {
                case None: {
                    if (this.hasLoggingHeader && bl) {
                        this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(this.loggingHeader + ' '), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                        break;
                    }
                    if (!this.hasLoggingHeader) break;
                    this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, this.loggingHeader + EOL));
                    break;
                }
                case HeaderStarted: {
                    assert (this.hasLoggingHeader);
                    if (bl) {
                        this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(" "), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                        break;
                    }
                    this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, EOL));
                    break;
                }
                case HeaderCompleted: {
                    if (!this.hasLoggingHeader || !bl) break;
                    this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(this.loggingHeader + ' '), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = State.Completed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        None,
        HeaderStarted,
        HeaderCompleted,
        Completed;

    }
}

