/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.FileDescriptor;
import java.io.PrintStream;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.nativeplatform.TerminalDetector;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.logging.internal.AnsiConsole;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.ConsoleBackedProgressRenderer;
import org.gradle.logging.internal.DefaultColorMap;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressLogEventGenerator;
import org.gradle.logging.internal.StreamBackedStandardOutputListener;
import org.gradle.logging.internal.StreamingStyledTextOutput;
import org.gradle.logging.internal.StyledTextOutputBackedRenderer;

public class OutputEventRenderer
implements OutputEventListener,
LoggingConfigurer,
LoggingOutputInternal {
    private final ListenerBroadcast<OutputEventListener> formatters = new ListenerBroadcast<OutputEventListener>(OutputEventListener.class);
    private final ListenerBroadcast<StandardOutputListener> stdoutListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private final ListenerBroadcast<StandardOutputListener> stderrListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private final TerminalDetector terminalDetector;
    private final Object lock = new Object();
    private final DefaultColorMap colourMap = new DefaultColorMap();
    private LogLevel logLevel = LogLevel.LIFECYCLE;

    public OutputEventRenderer(TerminalDetector terminalDetector) {
        OutputEventListener outputEventListener = this.onNonError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.stdoutListeners.getSource())), false));
        this.formatters.add(outputEventListener);
        OutputEventListener outputEventListener2 = this.onError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.stderrListeners.getSource())), false));
        this.formatters.add(outputEventListener2);
        this.terminalDetector = terminalDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void colorStdOutAndStdErr(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.colourMap.setUseColor(bl);
        }
    }

    public OutputEventRenderer addStandardOutputAndError() {
        boolean bl = this.terminalDetector.isTerminal(FileDescriptor.out);
        boolean bl2 = this.terminalDetector.isTerminal(FileDescriptor.err);
        if (bl) {
            PrintStream printStream = org.fusesource.jansi.AnsiConsole.out();
            AnsiConsole ansiConsole = new AnsiConsole(printStream, printStream, this.colourMap);
            this.addConsole(ansiConsole, true, bl2);
        } else if (bl2) {
            PrintStream printStream = org.fusesource.jansi.AnsiConsole.err();
            AnsiConsole ansiConsole = new AnsiConsole(printStream, printStream, this.colourMap);
            this.addConsole(ansiConsole, false, true);
        }
        if (!bl) {
            this.addStandardOutput(System.out);
        }
        if (!bl2) {
            this.addStandardError(System.err);
        }
        return this;
    }

    public OutputEventRenderer addStandardOutput(Appendable appendable) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(appendable));
        return this;
    }

    public OutputEventRenderer addStandardError(Appendable appendable) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(appendable));
        return this;
    }

    public void addOutputEventListener(OutputEventListener outputEventListener) {
        this.formatters.add(outputEventListener);
    }

    public void removeOutputEventListener(OutputEventListener outputEventListener) {
        this.formatters.remove(outputEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputEventRenderer addConsole(Console console, boolean bl, boolean bl2) {
        ConsoleBackedProgressRenderer consoleBackedProgressRenderer = new ConsoleBackedProgressRenderer(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(console.getMainArea()), true), console);
        Object object = this.lock;
        synchronized (object) {
            if (bl && bl2) {
                this.formatters.add(consoleBackedProgressRenderer);
            } else if (bl) {
                this.formatters.add(this.onNonError(consoleBackedProgressRenderer));
            } else {
                this.formatters.add(this.onError(consoleBackedProgressRenderer));
            }
        }
        return this;
    }

    private OutputEventListener onError(final OutputEventListener outputEventListener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent outputEvent) {
                if (outputEvent.getLogLevel() == LogLevel.ERROR || outputEvent.getLogLevel() == null) {
                    outputEventListener.onOutput(outputEvent);
                }
            }
        };
    }

    private OutputEventListener onNonError(final OutputEventListener outputEventListener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent outputEvent) {
                if (outputEvent.getLogLevel() != LogLevel.ERROR || outputEvent.getLogLevel() == null) {
                    outputEventListener.onOutput(outputEvent);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardErrorListener(StandardOutputListener standardOutputListener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.add(standardOutputListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardOutputListener(StandardOutputListener standardOutputListener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.add(standardOutputListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardOutputListener(StandardOutputListener standardOutputListener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.remove(standardOutputListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardErrorListener(StandardOutputListener standardOutputListener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.remove(standardOutputListener);
        }
    }

    public void configure(LogLevel logLevel) {
        this.onOutput(new LogLevelChangeEvent(logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent outputEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (outputEvent.getLogLevel() != null && outputEvent.getLogLevel().compareTo(this.logLevel) < 0) {
                return;
            }
            if (outputEvent instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent logLevelChangeEvent = (LogLevelChangeEvent)outputEvent;
                LogLevel logLevel = logLevelChangeEvent.getNewLogLevel();
                if (logLevel == this.logLevel) {
                    return;
                }
                this.logLevel = logLevel;
            }
            this.formatters.getSource().onOutput(outputEvent);
        }
    }
}

