/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerFilter
extends Filter<ILoggingEvent> {
    private final List<Marker> markers;
    private FilterReply onMismatch = FilterReply.NEUTRAL;

    public MarkerFilter(Marker ... markerArray) {
        this.markers = Arrays.asList(markerArray);
    }

    public MarkerFilter(FilterReply filterReply, Marker ... markerArray) {
        this(markerArray);
        this.onMismatch = filterReply;
    }

    public FilterReply decide(ILoggingEvent iLoggingEvent) {
        Marker marker = iLoggingEvent.getMarker();
        if (marker != null) {
            for (Marker marker2 : this.markers) {
                if (!marker.contains(marker2)) continue;
                return FilterReply.ACCEPT;
            }
        }
        return this.onMismatch;
    }

    public FilterReply getOnMismatch() {
        return this.onMismatch;
    }

    public void setOnMismatch(FilterReply filterReply) {
        this.onMismatch = filterReply;
    }

    public List getMarkers() {
        return this.markers;
    }
}

