/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.api.logging.LogLevel;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.LoggingSystem;

public class LoggingSystemAdapter
implements LoggingSystem {
    private final LoggingConfigurer configurer;
    private LogLevel logLevel = LogLevel.LIFECYCLE;

    public LoggingSystemAdapter(LoggingConfigurer loggingConfigurer) {
        this.configurer = loggingConfigurer;
    }

    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.logLevel);
    }

    public LoggingSystem.Snapshot off() {
        return new SnapshotImpl(this.logLevel);
    }

    public LoggingSystem.Snapshot on(LogLevel logLevel) {
        SnapshotImpl snapshotImpl = new SnapshotImpl(this.logLevel);
        this.setLevel(logLevel);
        return snapshotImpl;
    }

    public void restore(LoggingSystem.Snapshot snapshot) {
        LogLevel logLevel;
        this.logLevel = logLevel = ((SnapshotImpl)snapshot).level;
        if (logLevel != null) {
            this.configurer.configure(logLevel);
        }
    }

    private void setLevel(LogLevel logLevel) {
        this.configurer.configure(logLevel);
        this.logLevel = logLevel;
    }

    private class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final LogLevel level;

        public SnapshotImpl(LogLevel logLevel) {
            this.level = logLevel;
        }
    }
}

