/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.ShowStacktrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingCommandLineConverter
extends AbstractCommandLineConverter<LoggingConfiguration> {
    public static final String DEBUG = "d";
    public static final String DEBUG_LONG = "debug";
    public static final String INFO = "i";
    public static final String INFO_LONG = "info";
    public static final String QUIET = "q";
    public static final String QUIET_LONG = "quiet";
    public static final String NO_COLOR = "no-color";
    public static final String FULL_STACKTRACE = "S";
    public static final String FULL_STACKTRACE_LONG = "full-stacktrace";
    public static final String STACKTRACE = "s";
    public static final String STACKTRACE_LONG = "stacktrace";
    private final BiMap<String, LogLevel> logLevelMap = HashBiMap.create();
    private final BiMap<String, ShowStacktrace> showStacktraceMap = HashBiMap.create();

    public LoggingCommandLineConverter() {
        this.logLevelMap.put((Object)QUIET, (Object)LogLevel.QUIET);
        this.logLevelMap.put((Object)INFO, (Object)LogLevel.INFO);
        this.logLevelMap.put((Object)DEBUG, (Object)LogLevel.DEBUG);
        this.logLevelMap.put((Object)"", (Object)LogLevel.LIFECYCLE);
        this.showStacktraceMap.put((Object)FULL_STACKTRACE, (Object)ShowStacktrace.ALWAYS_FULL);
        this.showStacktraceMap.put((Object)STACKTRACE, (Object)ShowStacktrace.ALWAYS);
    }

    protected LoggingConfiguration newInstance() {
        return new LoggingConfiguration();
    }

    public LoggingConfiguration convert(ParsedCommandLine parsedCommandLine, LoggingConfiguration loggingConfiguration) throws CommandLineArgumentException {
        loggingConfiguration.setLogLevel(this.getLogLevel(parsedCommandLine));
        if (parsedCommandLine.hasOption(NO_COLOR)) {
            loggingConfiguration.setColorOutput(false);
        }
        loggingConfiguration.setShowStacktrace(this.getShowStacktrace(parsedCommandLine));
        return loggingConfiguration;
    }

    private ShowStacktrace getShowStacktrace(ParsedCommandLine parsedCommandLine) {
        if (parsedCommandLine.hasOption(FULL_STACKTRACE)) {
            return ShowStacktrace.ALWAYS_FULL;
        }
        if (parsedCommandLine.hasOption(STACKTRACE)) {
            return ShowStacktrace.ALWAYS;
        }
        return ShowStacktrace.INTERNAL_EXCEPTIONS;
    }

    private LogLevel getLogLevel(ParsedCommandLine parsedCommandLine) {
        LogLevel logLevel = LogLevel.LIFECYCLE;
        if (parsedCommandLine.hasOption(QUIET)) {
            logLevel = LogLevel.QUIET;
        }
        if (parsedCommandLine.hasOption(INFO)) {
            logLevel = LogLevel.INFO;
        }
        if (parsedCommandLine.hasOption(DEBUG)) {
            logLevel = LogLevel.DEBUG;
        }
        return logLevel;
    }

    public void configure(CommandLineParser commandLineParser) {
        commandLineParser.option(new String[]{DEBUG, DEBUG_LONG}).hasDescription("Log in debug mode (includes normal stacktrace).");
        commandLineParser.option(new String[]{QUIET, QUIET_LONG}).hasDescription("Log errors only.");
        commandLineParser.option(new String[]{INFO, INFO_LONG}).hasDescription("Set log level to info.");
        commandLineParser.option(new String[]{NO_COLOR}).hasDescription("Do not use color in the console output.");
        commandLineParser.option(new String[]{STACKTRACE, STACKTRACE_LONG}).hasDescription("Print out the stacktrace for all exceptions.");
        commandLineParser.option(new String[]{FULL_STACKTRACE, FULL_STACKTRACE_LONG}).hasDescription("Print out the full (very verbose) stacktrace for all exceptions.");
    }

    public LogLevel getLogLevel(String string) {
        LogLevel logLevel = (LogLevel)this.logLevelMap.get((Object)string);
        if (logLevel == null) {
            return null;
        }
        return logLevel;
    }

    public String getLogLevelCommandLine(LogLevel logLevel) {
        String string = (String)this.logLevelMap.inverse().get((Object)logLevel);
        if (string == null) {
            return null;
        }
        return string;
    }

    public Collection<LogLevel> getLogLevels() {
        return Collections.unmodifiableCollection(this.logLevelMap.values());
    }

    public Set<String> getLogLevelOptions() {
        HashSet<String> hashSet = new HashSet<String>(this.logLevelMap.keySet());
        hashSet.remove("");
        return hashSet;
    }

    public ShowStacktrace getShowStacktrace(String string) {
        ShowStacktrace showStacktrace = (ShowStacktrace)((Object)this.showStacktraceMap.get((Object)string));
        if (showStacktrace == null) {
            return null;
        }
        return showStacktrace;
    }

    public String getShowStacktraceCommandLine(ShowStacktrace showStacktrace) {
        String string = (String)this.showStacktraceMap.inverse().get((Object)showStacktrace);
        if (string == null) {
            return null;
        }
        return string;
    }
}

