/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.api.logging.LogLevel;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.RenderableOutputEvent;

public class LogEvent
extends RenderableOutputEvent {
    private final String message;
    private final Throwable throwable;

    public LogEvent(long l, String string, LogLevel logLevel, String string2, Throwable throwable) {
        super(l, string, logLevel);
        this.message = string2;
        this.throwable = throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void render(StyledTextOutput styledTextOutput) {
        styledTextOutput.text(this.message);
        styledTextOutput.println();
        if (this.throwable != null) {
            styledTextOutput.exception(this.throwable);
        }
    }

    public String toString() {
        return String.format("[%s] [%s] %s", this.getLogLevel(), this.getCategory(), this.message);
    }
}

