/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressListener;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.util.GUtil;
import org.gradle.util.TimeProvider;

public class DefaultProgressLoggerFactory
implements ProgressLoggerFactory {
    private final ProgressListener progressListener;
    private final TimeProvider timeProvider;

    public DefaultProgressLoggerFactory(ProgressListener progressListener, TimeProvider timeProvider) {
        this.progressListener = progressListener;
        this.timeProvider = timeProvider;
    }

    public ProgressLogger newOperation(Class clazz) {
        return this.newOperation(clazz.getName());
    }

    public ProgressLogger newOperation(String string) {
        return new ProgressLoggerImpl(string, this.progressListener, this.timeProvider);
    }

    private static class ProgressLoggerImpl
    implements ProgressLogger {
        private final String category;
        private final ProgressListener listener;
        private final TimeProvider timeProvider;
        private String description;
        private String shortDescription;
        private String loggingHeader;
        private State state = State.idle;

        public ProgressLoggerImpl(String string, ProgressListener progressListener, TimeProvider timeProvider) {
            this.category = string;
            this.listener = progressListener;
            this.timeProvider = timeProvider;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.assertCanConfigure();
            this.description = string;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public void setShortDescription(String string) {
            this.assertCanConfigure();
            this.shortDescription = string;
        }

        public String getLoggingHeader() {
            return this.loggingHeader;
        }

        public void setLoggingHeader(String string) {
            this.assertCanConfigure();
            this.loggingHeader = string;
        }

        public void started() {
            this.started(null);
        }

        public void started(String string) {
            if (!GUtil.isTrue(this.description)) {
                throw new IllegalStateException("A description must be specified before this operation is started.");
            }
            if (this.state == State.started) {
                throw new IllegalStateException("This operation has already been started.");
            }
            this.assertNotCompleted();
            this.state = State.started;
            this.listener.started(new ProgressStartEvent(this.timeProvider.getCurrentTime(), this.category, this.description, this.shortDescription, this.loggingHeader, this.toStatus(string)));
        }

        public void progress(String string) {
            this.assertStarted();
            this.assertNotCompleted();
            this.listener.progress(new ProgressEvent(this.timeProvider.getCurrentTime(), this.category, this.toStatus(string)));
        }

        public void completed() {
            this.completed(null);
        }

        public void completed(String string) {
            this.assertStarted();
            this.assertNotCompleted();
            this.state = State.completed;
            this.listener.completed(new ProgressCompleteEvent(this.timeProvider.getCurrentTime(), this.category, this.toStatus(string)));
        }

        private String toStatus(String string) {
            return string == null ? "" : string;
        }

        private void assertNotCompleted() {
            if (this.state == State.completed) {
                throw new IllegalStateException("This operation has completed.");
            }
        }

        private void assertStarted() {
            if (this.state == State.idle) {
                throw new IllegalStateException("This operation has not been started.");
            }
        }

        private void assertCanConfigure() {
            if (this.state != State.idle) {
                throw new IllegalStateException("Cannot configure this operation once it has started.");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            idle,
            started,
            completed;

        }
    }
}

