/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.LoggingSystem;
import org.gradle.logging.internal.OutputEventListener;

public class DefaultLoggingManager
implements LoggingManagerInternal {
    private boolean started;
    private final StartableLoggingSystem loggingSystem;
    private final StartableLoggingSystem stdOutLoggingSystem;
    private final StartableLoggingSystem stdErrLoggingSystem;
    private final LoggingOutputInternal loggingOutput;
    private final Set<StandardOutputListener> stdoutListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<StandardOutputListener> stderrListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<OutputEventListener> outputEventListeners = new LinkedHashSet<OutputEventListener>();

    public DefaultLoggingManager(LoggingSystem loggingSystem, LoggingSystem loggingSystem2, LoggingSystem loggingSystem3, LoggingOutputInternal loggingOutputInternal) {
        this.loggingOutput = loggingOutputInternal;
        this.loggingSystem = new StartableLoggingSystem(loggingSystem, null);
        this.stdOutLoggingSystem = new StartableLoggingSystem(loggingSystem2, LogLevel.QUIET);
        this.stdErrLoggingSystem = new StartableLoggingSystem(loggingSystem3, LogLevel.ERROR);
    }

    public DefaultLoggingManager start() {
        this.started = true;
        for (StandardOutputListener object : this.stdoutListeners) {
            this.loggingOutput.addStandardOutputListener(object);
        }
        for (StandardOutputListener standardOutputListener : this.stderrListeners) {
            this.loggingOutput.addStandardErrorListener(standardOutputListener);
        }
        for (OutputEventListener outputEventListener : this.outputEventListeners) {
            this.loggingOutput.addOutputEventListener(outputEventListener);
        }
        this.loggingSystem.start();
        this.stdOutLoggingSystem.start();
        this.stdErrLoggingSystem.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultLoggingManager stop() {
        try {
            new CompositeStoppable(new Object[]{this.loggingSystem, this.stdOutLoggingSystem, this.stdErrLoggingSystem}).stop();
            for (StandardOutputListener object : this.stdoutListeners) {
                this.loggingOutput.removeStandardOutputListener(object);
            }
            for (StandardOutputListener standardOutputListener : this.stderrListeners) {
                this.loggingOutput.removeStandardErrorListener(standardOutputListener);
            }
            for (OutputEventListener outputEventListener : this.outputEventListeners) {
                this.loggingOutput.removeOutputEventListener(outputEventListener);
            }
        }
        finally {
            this.started = false;
        }
        return this;
    }

    public DefaultLoggingManager setLevel(LogLevel logLevel) {
        this.loggingSystem.setLevel(logLevel);
        return this;
    }

    public LogLevel getLevel() {
        return this.loggingSystem.level;
    }

    public LogLevel getStandardOutputCaptureLevel() {
        return this.stdOutLoggingSystem.level;
    }

    public DefaultLoggingManager captureStandardOutput(LogLevel logLevel) {
        this.stdOutLoggingSystem.setLevel(logLevel);
        return this;
    }

    public DefaultLoggingManager captureStandardError(LogLevel logLevel) {
        this.stdErrLoggingSystem.setLevel(logLevel);
        return this;
    }

    public LogLevel getStandardErrorCaptureLevel() {
        return this.stdErrLoggingSystem.level;
    }

    public void addStandardOutputListener(StandardOutputListener standardOutputListener) {
        if (this.stdoutListeners.add(standardOutputListener) && this.started) {
            this.loggingOutput.addStandardOutputListener(standardOutputListener);
        }
    }

    public void addStandardErrorListener(StandardOutputListener standardOutputListener) {
        if (this.stderrListeners.add(standardOutputListener) && this.started) {
            this.loggingOutput.addStandardErrorListener(standardOutputListener);
        }
    }

    public void removeStandardOutputListener(StandardOutputListener standardOutputListener) {
        if (this.stdoutListeners.remove(standardOutputListener) && this.started) {
            this.loggingOutput.removeStandardOutputListener(standardOutputListener);
        }
    }

    public void removeStandardErrorListener(StandardOutputListener standardOutputListener) {
        if (this.stderrListeners.remove(standardOutputListener) && this.started) {
            this.loggingOutput.removeStandardErrorListener(standardOutputListener);
        }
    }

    public void addOutputEventListener(OutputEventListener outputEventListener) {
        if (this.outputEventListeners.add(outputEventListener) && this.started) {
            this.loggingOutput.addOutputEventListener(outputEventListener);
        }
    }

    public void removeOutputEventListener(OutputEventListener outputEventListener) {
        if (this.outputEventListeners.remove(outputEventListener) && this.started) {
            this.loggingOutput.removeOutputEventListener(outputEventListener);
        }
    }

    public void colorStdOutAndStdErr(boolean bl) {
        this.loggingOutput.colorStdOutAndStdErr(bl);
    }

    private static class StartableLoggingSystem
    implements Stoppable {
        private final LoggingSystem loggingSystem;
        private LogLevel level;
        private boolean disable;
        private LoggingSystem.Snapshot originalState;

        private StartableLoggingSystem(LoggingSystem loggingSystem, LogLevel logLevel) {
            this.loggingSystem = loggingSystem;
            this.level = logLevel;
        }

        public void start() {
            this.originalState = this.disable ? this.loggingSystem.off() : (this.level != null ? this.loggingSystem.on(this.level) : this.loggingSystem.snapshot());
        }

        public void setLevel(LogLevel logLevel) {
            if (this.level == logLevel) {
                return;
            }
            this.level = logLevel;
            this.disable = false;
            if (this.originalState == null) {
                return;
            }
            this.loggingSystem.on(logLevel);
        }

        public void disable() {
            this.level = null;
            this.disable = true;
            if (this.originalState != null) {
                this.loggingSystem.off();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                if (this.originalState != null) {
                    this.loggingSystem.restore(this.originalState);
                }
            }
            finally {
                this.originalState = null;
            }
        }
    }
}

