/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.logging.internal.LoggingConfigurer;

public class DefaultLoggingConfigurer
implements LoggingConfigurer {
    private static final Logger LOGGER = Logging.getLogger(DefaultLoggingConfigurer.class);
    private final List<LoggingConfigurer> configurers = new ArrayList<LoggingConfigurer>();

    public DefaultLoggingConfigurer(LoggingConfigurer ... loggingConfigurerArray) {
        this.configurers.addAll(Arrays.asList(loggingConfigurerArray));
    }

    public void add(LoggingConfigurer loggingConfigurer) {
        this.configurers.add(loggingConfigurer);
    }

    public void configure(LogLevel logLevel) {
        for (LoggingConfigurer loggingConfigurer : this.configurers) {
            loggingConfigurer.configure(logLevel);
        }
        LOGGER.debug("Finished configuring with level: {}, configurers: {}", logLevel, this.configurers);
    }
}

